/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.data.cache;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.data.cache.DataSnapshot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaDataSnapshotSerializer
implements DataSnapshotSerializer {
    private static final Log log = LogFactory.getLog(JavaDataSnapshotSerializer.class);

    @Override
    public void writeSnapshot(DataSnapshot snapshot, OutputStream out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serializing data snapshot of type " + snapshot.getClass().getName()));
        }
        ObjectOutputStream objectOut = new ObjectOutputStream(out);
        objectOut.writeObject(snapshot);
    }

    @Override
    public DataSnapshot readSnapshot(InputStream in) throws IOException {
        DataSnapshot snapshot;
        if (log.isDebugEnabled()) {
            log.debug((Object)"deserializing data snapshot");
        }
        ObjectInputStream objectInput = new ObjectInputStream(in);
        try {
            snapshot = (DataSnapshot)objectInput.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new JSExceptionWrapper("Failed to deserialize data snapshot", (Exception)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("deserialized data snapshot of type " + snapshot.getClass().getName()));
        }
        return snapshot;
    }
}

