/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.GzipDataContainer;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.Arrays;

public class DataContainerStreamUtil {
    private static final Log log = LogFactory.getLog(DataContainerStreamUtil.class);
    private static final int READ_STREAM_BUFFER_SIZE = 10000;
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 16, 0, 0, 0, 0, 0, 0, 106, 114, 115, 97, 0};

    public static byte[] readData(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[10000];
        int ln = 0;
        try {
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while reading data.", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readDataAndClose(InputStream is) {
        try {
            byte[] byArray = DataContainerStreamUtil.readData(is);
            return byArray;
        }
        finally {
            DataContainerStreamUtil.close(is);
        }
    }

    public static byte[] readData(InputStream is, int size) {
        if (is == null) {
            return null;
        }
        try {
            byte[] data = new byte[size];
            int offset = 0;
            while (size > 0) {
                int read = is.read(data, offset, size);
                if (read < 0) {
                    throw new JSException("jsexception.input.stream.exhausted", new Object[]{new Integer(size)});
                }
                offset += read;
                size -= read;
            }
            return data;
        }
        catch (IOException e) {
            log.error((Object)"Error while reading data.", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public static byte[] readData(Blob blob) {
        if (blob == null) {
            return null;
        }
        try {
            return DataContainerStreamUtil.readData(blob.getBinaryStream());
        }
        catch (SQLException e) {
            log.error((Object)"Error while reading blob data", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public static void pipeData(InputStream is, OutputStream os) throws IOException {
        if (is == null) {
            return;
        }
        byte[] bytes = new byte[10000];
        int ln = 0;
        while ((ln = is.read(bytes)) > 0) {
            os.write(bytes, 0, ln);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipeDataAndCloseInput(InputStream is, OutputStream os) throws IOException {
        try {
            DataContainerStreamUtil.pipeData(is, os);
        }
        finally {
            DataContainerStreamUtil.close(is);
        }
    }

    protected static void close(InputStream is) {
        try {
            is.close();
        }
        catch (IOException e) {
            log.warn((Object)("Failed to close input stream " + is), (Throwable)e);
        }
    }

    public static void writeObjectByteData(ObjectOutputStream objectStream, InputStream data) throws IOException {
        DataContainerStreamUtil.pipeData(data, objectStream);
    }

    public static void readObjectByteData(ObjectInputStream objectStream, int size, OutputStream outStream) throws IOException {
        byte[] buffer = new byte[10000];
        while (size > 0) {
            int read = buffer.length;
            if (read > size) {
                read = size;
            }
            objectStream.readFully(buffer, 0, read);
            outStream.write(buffer, 0, read);
            size -= read;
        }
    }

    public static void pipeData(InputStream is, DataContainer dataContainer) {
        boolean close = true;
        OutputStream out = dataContainer.getOutputStream();
        try {
            DataContainerStreamUtil.pipeData(is, out);
            close = false;
            out.close();
        }
        catch (IOException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (close) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing stream", (Throwable)e);
                }
            }
        }
    }

    public static DataContainer pipeGzipSniffedData(InputStream is, DataContainer dataContainer) {
        GzipSniffInputStream gzipSniffInput = new GzipSniffInputStream(is);
        DataContainerStreamUtil.pipeData((InputStream)gzipSniffInput, dataContainer);
        if (gzipSniffInput.isAutoGzip()) {
            int uncompressedLength = gzipSniffInput.gzipUncompressedLength();
            return new GzipDataContainer(dataContainer, uncompressedLength);
        }
        return dataContainer;
    }

    public static DataContainer createCompressedContainer(DataContainer container) {
        return new GzipDataContainer(container);
    }

    public static DataContainer getRawDataContainer(DataContainer container) {
        if (container instanceof GzipDataContainer) {
            return ((GzipDataContainer)container).getDecorated();
        }
        return container;
    }

    protected static class CompressedOutputStream
    extends DeflaterOutputStream {
        private CRC32 crc = new CRC32();

        public CompressedOutputStream(OutputStream out) throws IOException {
            super(out, new Deflater(-1, true));
            this.crc.reset();
            out.write(GZIP_HEADER);
        }

        @Override
        public synchronized void write(byte[] buf, int off, int len) throws IOException {
            super.write(buf, off, len);
            this.crc.update(buf, off, len);
        }

        @Override
        public void finish() throws IOException {
            super.finish();
            int crcValue = (int)this.crc.getValue();
            int size = this.getUncompressedSize();
            if (log.isDebugEnabled()) {
                log.debug((Object)("writing gzip trailer for crc " + crcValue + ", length " + size));
            }
            byte[] trailer = new byte[]{(byte)(crcValue & 0xFF), (byte)(crcValue >> 8 & 0xFF), (byte)(crcValue >> 16 & 0xFF), (byte)(crcValue >> 24 & 0xFF), (byte)(size & 0xFF), (byte)(size >> 8 & 0xFF), (byte)(size >> 16 & 0xFF), (byte)(size >> 24 & 0xFF)};
            this.out.write(trailer);
        }

        protected int getUncompressedSize() {
            return this.def.getTotalIn();
        }
    }

    protected static class GzipSniffInputStream
    extends FilterInputStream {
        private static final int LENGTH_TRAILER_SIZE = 4;
        private int headerOffset = 0;
        private final byte[] header = new byte[DataContainerStreamUtil.access$000().length];
        private int trailerOffset = 0;
        private final byte[] trailer = new byte[4];

        public GzipSniffInputStream(InputStream in) {
            super(in);
        }

        private void bufferHeader(byte b) {
            if (this.headerOffset < this.header.length) {
                this.header[this.headerOffset] = b;
                ++this.headerOffset;
            }
        }

        private void bufferHeader(byte[] b, int off, int read) {
            if (this.headerOffset < this.header.length) {
                int count = Math.min(this.header.length - this.headerOffset, read);
                System.arraycopy(b, off, this.header, this.headerOffset, count);
                this.headerOffset += count;
            }
        }

        private void bufferTrailer(byte b) {
            this.trailer[this.trailerOffset] = b;
            ++this.trailerOffset;
            if (this.trailerOffset == 4) {
                this.trailerOffset = 0;
            }
        }

        private void bufferTrailer(byte[] b, int off, int read) {
            int lastCount = Math.min(read, 4);
            for (int i = 0; i < lastCount; ++i) {
                this.bufferTrailer(b[off + read - lastCount + i]);
            }
        }

        @Override
        public int read() throws IOException {
            int read = super.read();
            if (read >= 0) {
                byte b = (byte)(read & 0xFF);
                this.bufferHeader(b);
                this.bufferTrailer(b);
            }
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = super.read(b, off, len);
            if (read > 0) {
                this.bufferHeader(b, off, read);
                this.bufferTrailer(b, off, read);
            }
            return read;
        }

        public boolean isAutoGzip() {
            if (this.headerOffset < GZIP_HEADER.length) {
                return false;
            }
            boolean isGzip = Arrays.areEqual((byte[])this.header, (byte[])GZIP_HEADER);
            if (isGzip && log.isDebugEnabled()) {
                log.debug((Object)"detected gzip stream");
            }
            return isGzip;
        }

        public int gzipUncompressedLength() {
            int length = this.trailer[this.trailerOffset] & 0xFF | (this.trailer[(this.trailerOffset + 1) % 4] & 0xFF) << 8 | (this.trailer[(this.trailerOffset + 2) % 4] & 0xFF) << 16 | (this.trailer[(this.trailerOffset + 3) % 4] & 0xFF) << 24;
            if (log.isDebugEnabled()) {
                log.debug((Object)("gzip uncompressed length " + length));
            }
            return length;
        }
    }
}

