/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventMappingFunction;
import net.sf.saxon.evpull.EventMappingIterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.PositionVariable;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.SingletonComparison;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.StatefulMappingFunction;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;

public class ForExpression
extends Assignation {
    protected PositionVariable positionVariable = null;

    public void setPositionVariable(PositionVariable decl) {
        this.positionVariable = decl;
    }

    public StructuredQName getPositionVariableName() {
        if (this.positionVariable == null) {
            return null;
        }
        return this.positionVariable.getVariableQName();
    }

    public void setSlotNumber(int nr) {
        super.setSlotNumber(nr);
        if (this.positionVariable != null) {
            this.positionVariable.setSlotNumber(nr + 1);
        }
    }

    public int getRequiredSlots() {
        return this.positionVariable == null ? 1 : 2;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.sequence = visitor.typeCheck(this.sequence, contextItemType);
        if (Literal.isEmptySequence(this.sequence)) {
            return this.sequence;
        }
        if (this.requiredType != null) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            SequenceType decl = this.requiredType;
            SequenceType sequenceType = SequenceType.makeSequenceType(decl.getPrimaryType(), 57344);
            RoleLocator role = new RoleLocator(3, this.variableName, 0);
            this.sequence = TypeChecker.strictTypeCheck(this.sequence, sequenceType, role, visitor.getStaticContext());
            ItemType actualItemType = this.sequence.getItemType(th);
            this.refineTypeInformation(actualItemType, this.getRangeVariableCardinality(), null, this.sequence.getSpecialProperties(), visitor, this);
        }
        this.action = visitor.typeCheck(this.action, contextItemType);
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        return this;
    }

    protected int getRangeVariableCardinality() {
        return 16384;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression seq2;
        Expression p;
        Expression act2;
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        boolean debug = opt.getConfiguration().isOptimizerTracing();
        if (Choose.isSingleBranchChoice(this.action) && (act2 = visitor.optimize(this.action, contextItemType)) != this.action) {
            this.action = act2;
            this.adoptChildExpression(this.action);
            visitor.resetStaticProperties();
        }
        if ((p = this.promoteWhereClause(this.positionVariable)) != null) {
            if (debug) {
                opt.trace("Promoted where clause in for $" + this.getVariableName(), p);
            }
            return visitor.optimize(p, contextItemType);
        }
        Expression pred = this.convertWhereToPredicate(visitor, contextItemType);
        if (pred != null) {
            if (debug) {
                opt.trace("Converted where clause in for $" + this.getVariableName() + " to predicate", pred);
            }
            if (pred != this) {
                return visitor.optimize(pred, contextItemType);
            }
        }
        if ((seq2 = visitor.optimize(this.sequence, contextItemType)) != this.sequence) {
            this.sequence = seq2;
            this.adoptChildExpression(this.sequence);
            visitor.resetStaticProperties();
            return this.optimize(visitor, contextItemType);
        }
        if (Literal.isEmptySequence(this.sequence)) {
            return this.sequence;
        }
        Expression act22 = visitor.optimize(this.action, contextItemType);
        if (act22 != this.action) {
            this.action = act22;
            this.adoptChildExpression(this.action);
            visitor.resetStaticProperties();
            return this.optimize(visitor, contextItemType);
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        Expression e2 = this.extractLoopInvariants(visitor, contextItemType);
        if (e2 != null && e2 != this) {
            if (debug) {
                opt.trace("Extracted invariant in 'for $" + this.getVariableName() + "' loop", e2);
            }
            return visitor.optimize(e2, contextItemType);
        }
        if (this.positionVariable == null && this.sequence instanceof SlashExpression && this.action instanceof SlashExpression) {
            SlashExpression path2 = (SlashExpression)this.action;
            Expression start2 = path2.getControllingExpression();
            Expression step2 = path2.getControlledExpression();
            if (start2 instanceof VariableReference && ((VariableReference)start2).getBinding() == this && ExpressionTool.getReferenceCount(this.action, this, false) == 1 && (step2.getDependencies() & 0xC) == 0) {
                Expression newPath = new SlashExpression(this.sequence, path2.getControlledExpression());
                ExpressionTool.copyLocationInfo(this, newPath);
                newPath = visitor.typeCheck(visitor.simplify(newPath), contextItemType);
                if (newPath instanceof SlashExpression) {
                    if (debug) {
                        opt.trace("Collapsed return clause of for $" + this.getVariableName() + " into path expression", newPath);
                    }
                    return visitor.optimize(newPath, contextItemType);
                }
            }
        }
        if (this.action instanceof VariableReference && ((VariableReference)this.action).getBinding() == this) {
            if (debug) {
                opt.trace("Collapsed redundant for expression $" + this.getVariableName(), this.sequence);
            }
            return this.sequence;
        }
        if (this.action instanceof VariableReference && ((VariableReference)this.action).getBinding() == this.positionVariable) {
            FunctionCall count = SystemFunction.makeSystemFunction("count", new Expression[]{this.sequence});
            RangeExpression range = new RangeExpression(new Literal(Int64Value.PLUS_ONE), 29, count);
            if (debug) {
                opt.trace("Replaced 'for $x at $p in EXP return $p' by '1 to count(EXP)'", range);
            }
            return range.optimize(visitor, contextItemType);
        }
        if (this.sequence.getCardinality() == 16384 && this.positionVariable == null) {
            LetExpression let = new LetExpression();
            let.setVariableQName(this.variableName);
            let.setRequiredType(SequenceType.makeSequenceType(this.sequence.getItemType(visitor.getConfiguration().getTypeHierarchy()), 16384));
            let.setSequence(this.sequence);
            let.setAction(this.action);
            let.setSlotNumber(this.slotNumber);
            ExpressionTool.rebindVariableReferences(this.action, this, let);
            return let.optimize(visitor, contextItemType);
        }
        return this;
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action;
    }

    private Expression extractLoopInvariants(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        PromotionOffer offer = new PromotionOffer(visitor.getConfiguration().getOptimizer());
        offer.containingExpression = this;
        offer.action = 11;
        offer.bindingList = this.positionVariable == null ? new Binding[]{this} : new Binding[]{this, this.positionVariable};
        this.action = this.doPromotion(this, this.action, offer);
        if (offer.containingExpression instanceof LetExpression) {
            offer.containingExpression = visitor.optimize(offer.containingExpression, contextItemType);
        }
        return offer.containingExpression;
    }

    private Expression convertWhereToPredicate(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (Choose.isSingleBranchChoice(this.action)) {
            Expression e2;
            this.action = this.action.optimize(visitor, contextItemType);
            if (ExpressionTool.dependsOnFocus(this.action) && (e2 = ExpressionTool.tryToFactorOutDot(this, contextItemType)) != null) {
                return e2;
            }
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            Optimizer opt = visitor.getConfiguration().getOptimizer();
            Expression head = null;
            Expression selection = this.sequence;
            ItemType selectionContextItemType = contextItemType;
            if (this.sequence instanceof PathExpression) {
                if (((PathExpression)this.sequence).isAbsolute(th)) {
                    head = ((PathExpression)this.sequence).getFirstStep();
                    selection = ((PathExpression)this.sequence).getRemainingSteps();
                    selectionContextItemType = head.getItemType(th);
                } else {
                    PathExpression p = ((PathExpression)this.sequence).tryToMakeAbsolute(th);
                    if (p != null) {
                        this.sequence = p;
                        this.adoptChildExpression(p);
                        head = ((PathExpression)this.sequence).getFirstStep();
                        selection = ((PathExpression)this.sequence).getRemainingSteps();
                        selectionContextItemType = head.getItemType(th);
                    }
                }
            }
            boolean changed = false;
            Expression condition = ((Choose)this.action).getConditions()[0];
            ArrayList list = new ArrayList(4);
            BooleanExpression.listAndComponents(condition, list);
            for (int t = list.size() - 1; t >= 0; --t) {
                Expression replacement;
                Binding[] thisVar;
                Expression term = (Expression)list.get(t);
                if (this.positionVariable != null && (term instanceof ValueComparison || term instanceof SingletonComparison)) {
                    BinaryExpression comp = (BinaryExpression)term;
                    Expression[] operands = comp.getOperands();
                    for (int op = 0; op < 2; ++op) {
                        BinaryExpression predicate;
                        Binding[] thisVar2 = new Binding[]{this};
                        if (this.positionVariable == null || !(operands[op] instanceof VariableReference) || changed) continue;
                        ArrayList varRefs = new ArrayList();
                        ExpressionTool.gatherVariableReferences(this.action, this.positionVariable, varRefs);
                        if (varRefs.size() != 1 || varRefs.get(0) != operands[op] || ExpressionTool.dependsOnFocus(operands[1 - op]) || ExpressionTool.dependsOnVariable(operands[1 - op], thisVar2)) continue;
                        FunctionCall position = SystemFunction.makeSystemFunction("position", SimpleExpression.NO_ARGUMENTS);
                        if (term instanceof ValueComparison) {
                            predicate = op == 0 ? new ValueComparison(position, comp.getOperator(), operands[1]) : new ValueComparison(operands[0], comp.getOperator(), position);
                        } else {
                            boolean checkTypes = ((SingletonComparison)term).needsRuntimeComparabilityCheck();
                            predicate = op == 0 ? new SingletonComparison(position, comp.getOperator(), operands[1], checkTypes) : new SingletonComparison(operands[0], comp.getOperator(), position, checkTypes);
                        }
                        selection = new FilterExpression(selection, predicate);
                        ExpressionTool.copyLocationInfo(this, selection);
                        selection = visitor.typeCheck(selection, selectionContextItemType);
                        this.positionVariable = null;
                        list.remove(t);
                        changed = true;
                        break;
                    }
                }
                if (this.positionVariable != null || !opt.isVariableReplaceableByDot(term, thisVar = new Binding[]{this}) || ExpressionTool.dependsOnFocus(term)) continue;
                boolean useDotDirectly = opt.isVariableReplaceableByDot(term, thisVar);
                if (useDotDirectly) {
                    replacement = new ContextItemExpression();
                } else {
                    LetExpression let = new LetExpression();
                    let.setVariableQName(new StructuredQName("saxon", "http://saxon.sf.net/", "dot" + this.hashCode()));
                    let.setRequiredType(SequenceType.makeSequenceType(contextItemType, 16384));
                    let.setSequence(new ContextItemExpression());
                    let.setAction(term);
                    term = let;
                    replacement = new VariableReference(let);
                }
                PromotionOffer offer = new PromotionOffer(visitor.getConfiguration().getOptimizer());
                offer.action = 12;
                offer.bindingList = thisVar;
                offer.containingExpression = replacement;
                Expression newTerm = term.promote(offer, this);
                if (newTerm == null || !offer.accepted) continue;
                Expression predicate = visitor.typeCheck(newTerm, this.sequence.getItemType(th));
                int rel = th.relationship(predicate.getItemType(th), BuiltInAtomicType.INTEGER);
                if (rel != 4) {
                    predicate = SystemFunction.makeSystemFunction("boolean", new Expression[]{predicate});
                }
                selection = new FilterExpression(selection, predicate);
                ExpressionTool.copyLocationInfo(this, selection);
                selection = visitor.typeCheck(selection, selectionContextItemType);
                changed = true;
                list.remove(t);
            }
            if (changed) {
                if (list.isEmpty()) {
                    this.action = ((Choose)this.action).getActions()[0];
                    this.adoptChildExpression(this.action);
                } else {
                    Expression term = (Expression)list.get(0);
                    for (int t = 1; t < list.size(); ++t) {
                        term = new BooleanExpression(term, 10, (Expression)list.get(t));
                    }
                    ((Choose)this.action).getConditions()[0] = term;
                }
                if (head == null) {
                    this.sequence = selection;
                } else if (head instanceof RootExpression && selection instanceof KeyFn) {
                    this.sequence = selection;
                } else {
                    PathExpression path = new PathExpression(head, selection);
                    ExpressionTool.copyLocationInfo(this, path);
                    Expression k = visitor.getConfiguration().getOptimizer().convertPathExpressionToKey(path, visitor);
                    this.sequence = k == null ? path : k;
                    this.sequence = visitor.optimize(visitor.typeCheck(visitor.simplify(this.sequence), contextItemType), contextItemType);
                    this.adoptChildExpression(this.sequence);
                }
                return this;
            }
        }
        return null;
    }

    public Expression copy() {
        ForExpression forExp = new ForExpression();
        forExp.setRequiredType(this.requiredType);
        forExp.setVariableQName(this.variableName);
        forExp.setSequence(this.sequence.copy());
        Expression newAction = this.action.copy();
        forExp.setAction(newAction);
        forExp.variableName = this.variableName;
        ExpressionTool.rebindVariableReferences(newAction, this, forExp);
        if (this.positionVariable != null) {
            PositionVariable pv2 = new PositionVariable();
            pv2.setVariableQName(this.positionVariable.getVariableQName());
            forExp.setPositionVariable(pv2);
            ExpressionTool.rebindVariableReferences(newAction, this.positionVariable, pv2);
        }
        return forExp;
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        if (!Cardinality.allowsMany(this.sequence.getCardinality())) {
            return ExpressionTool.markTailFunctionCalls(this.action, qName, arity);
        }
        return 0;
    }

    public Binding[] extendBindingList(Binding[] in) {
        if (this.positionVariable == null) {
            return super.extendBindingList(in);
        }
        Binding[] newBindingList = new Binding[in.length + 2];
        System.arraycopy(in, 0, newBindingList, 0, in.length);
        newBindingList[in.length] = this;
        newBindingList[in.length + 1] = this.positionVariable;
        return newBindingList;
    }

    public boolean isVacuousExpression() {
        return this.action.isVacuousExpression();
    }

    public int getImplementationMethod() {
        return 6;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, false);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.sequence.iterate(context);
        int pslot = this.positionVariable == null ? -1 : this.positionVariable.getLocalSlotNumber();
        MappingAction map = new MappingAction(context, this.getLocalSlotNumber(), pslot, this.action);
        return new MappingIterator(base, map);
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        SequenceIterator base = this.sequence.iterate(context);
        EventMappingAction map = new EventMappingAction(context, this.getLocalSlotNumber(), this.positionVariable, this.action);
        return new EventMappingIterator(base, map);
    }

    public void process(XPathContext context) throws XPathException {
        Item item;
        SequenceIterator iter = this.sequence.iterate(context);
        int position = 1;
        int slot = this.getLocalSlotNumber();
        int pslot = -1;
        if (this.positionVariable != null) {
            pslot = this.positionVariable.getLocalSlotNumber();
        }
        while ((item = iter.next()) != null) {
            context.setLocalVariable(slot, item);
            if (pslot >= 0) {
                context.setLocalVariable(pslot, Int64Value.makeIntegerValue(position++));
            }
            this.action.process(context);
        }
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        Item item;
        SequenceIterator iter = this.sequence.iterate(context);
        int position = 1;
        int slot = this.getLocalSlotNumber();
        int pslot = -1;
        if (this.positionVariable != null) {
            pslot = this.positionVariable.getLocalSlotNumber();
        }
        while ((item = iter.next()) != null) {
            context.setLocalVariable(slot, item);
            if (pslot >= 0) {
                context.setLocalVariable(pslot, Int64Value.makeIntegerValue(position++));
            }
            this.action.evaluatePendingUpdates(context, pul);
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.action.getItemType(th);
    }

    public int computeCardinality() {
        int c1 = this.sequence.getCardinality();
        int c2 = this.action.getCardinality();
        return Cardinality.multiply(c1, c2);
    }

    public String toString() {
        return "for $" + this.getVariableName() + " in " + (this.sequence == null ? "(...)" : this.sequence.toString()) + " return " + (this.action == null ? "(...)" : this.action.toString());
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("for");
        this.explainSpecializedAttributes(out);
        out.emitAttribute("variable", this.getVariableName());
        out.emitAttribute("as", this.sequence.getItemType(out.getTypeHierarchy()).toString(out.getNamePool()));
        if (this.positionVariable != null) {
            out.emitAttribute("at", this.positionVariable.getVariableQName().getDisplayName());
        }
        out.startSubsidiaryElement("in");
        this.sequence.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("return");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    protected void explainSpecializedAttributes(ExpressionPresenter out) {
    }

    public int getConstructType() {
        return 2012;
    }

    protected static class EventMappingAction
    implements EventMappingFunction {
        private XPathContext context;
        private int slotNumber;
        private Expression action;
        private int position = 1;
        private int pslot = -1;

        public EventMappingAction(XPathContext context, int slotNumber, PositionVariable positionBinding, Expression action) {
            this.context = context;
            this.slotNumber = slotNumber;
            if (positionBinding != null) {
                this.pslot = positionBinding.getLocalSlotNumber();
            }
            this.action = action;
        }

        public EventIterator map(Item item) throws XPathException {
            this.context.setLocalVariable(this.slotNumber, item);
            if (this.pslot >= 0) {
                this.context.setLocalVariable(this.pslot, Int64Value.makeIntegerValue(this.position++));
            }
            return this.action.iterateEvents(this.context);
        }
    }

    protected static class MappingAction
    implements StatefulMappingFunction {
        private XPathContext context;
        private int slotNumber;
        private Expression action;
        private int pslot = -1;
        private int position = 1;

        public MappingAction(XPathContext context, int slotNumber, int pslot, Expression action) {
            this.context = context;
            this.slotNumber = slotNumber;
            this.pslot = pslot;
            this.action = action;
        }

        public SequenceIterator map(Item item) throws XPathException {
            this.context.setLocalVariable(this.slotNumber, item);
            if (this.pslot >= 0) {
                this.context.setLocalVariable(this.pslot, Int64Value.makeIntegerValue(this.position++));
            }
            return this.action.iterate(this.context);
        }

        public StatefulMappingFunction getAnother() {
            XPathContextMajor c2 = this.context.newContext();
            StackFrame oldstack = this.context.getStackFrame();
            ValueRepresentation[] vars = oldstack.getStackFrameValues();
            ValueRepresentation[] newvars = new ValueRepresentation[vars.length];
            System.arraycopy(vars, 0, newvars, 0, vars.length);
            c2.setStackFrame(oldstack.getStackFrameMap(), newvars);
            return new MappingAction(c2, this.slotNumber, this.pslot, this.action);
        }
    }
}

