/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.util.Assertion;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.ContextReference;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Reference
implements Expression,
ContextReference {
    private boolean positional;
    private boolean optional;
    private int refIndex;
    private Class<?> type;
    private ElementSymbol expression;
    private Constraint constraint;

    public Reference(int refIndex) {
        this.refIndex = refIndex;
        this.positional = true;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public Reference(ElementSymbol expression) {
        this.expression = expression;
        this.positional = false;
    }

    private Reference(Reference ref) {
        this.refIndex = ref.refIndex;
        this.positional = ref.positional;
        this.type = ref.type;
        if (ref.expression != null) {
            this.expression = ref.expression.clone();
        }
        this.constraint = ref.constraint;
        this.optional = ref.optional;
    }

    public int getIndex() {
        return this.refIndex;
    }

    @Override
    public String getContextSymbol() {
        return "$param/pos" + this.refIndex;
    }

    public ElementSymbol getExpression() {
        return this.expression;
    }

    @Override
    public Class<?> getType() {
        if (this.isPositional() && this.expression == null) {
            return this.type;
        }
        return this.expression.getType();
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        return new Reference(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)obj;
        if (this.positional != other.positional) {
            return false;
        }
        if (this.positional) {
            return other.getIndex() == this.getIndex();
        }
        return this.expression.equals(other.expression);
    }

    public void setType(Class<?> type) {
        Assertion.assertTrue((boolean)this.positional);
        this.type = type;
    }

    public int hashCode() {
        if (this.isPositional()) {
            return this.getIndex();
        }
        return this.expression.hashCode();
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean isCorrelated() {
        if (this.isPositional()) {
            return false;
        }
        if (this.expression.getGroupSymbol() == null || !(this.expression.getGroupSymbol().getMetadataID() instanceof TempMetadataID)) {
            return true;
        }
        TempMetadataID tid = (TempMetadataID)this.expression.getGroupSymbol().getMetadataID();
        return !tid.isScalarGroup();
    }

    public boolean isPositional() {
        return this.positional;
    }

    public void setExpression(ElementSymbol expression) {
        assert (this.expression != null && !this.positional);
        this.expression = expression;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public static interface Constraint {
        public void validate(Object var1) throws QueryValidatorException;
    }
}

