/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.teiid.common.buffer.TupleSource;

public class CollectionTupleSource
implements TupleSource {
    private Iterator<? extends List<?>> tuples;

    public static CollectionTupleSource createUpdateCountTupleSource(int count) {
        return new CollectionTupleSource(Arrays.asList(Arrays.asList(count)).iterator());
    }

    public static CollectionTupleSource createNullTupleSource() {
        return new CollectionTupleSource(new ArrayList(0).iterator());
    }

    public CollectionTupleSource(Iterator<? extends List<?>> tuples) {
        this.tuples = tuples;
    }

    @Override
    public List<?> nextTuple() {
        if (this.tuples.hasNext()) {
            return this.tuples.next();
        }
        return null;
    }

    @Override
    public void closeSource() {
    }
}

