/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.export.ExportTaskImpl;
import com.jaspersoft.jasperserver.export.Exporter;
import com.jaspersoft.jasperserver.export.ImportTaskImpl;
import com.jaspersoft.jasperserver.export.Importer;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.ParametersImpl;
import com.jaspersoft.jasperserver.export.io.PathProcessor;
import com.jaspersoft.jasperserver.export.io.PathProcessorFactory;
import com.jaspersoft.jasperserver.export.io.ZipFileInput;
import com.jaspersoft.jasperserver.export.io.ZipFileInputManager;
import com.jaspersoft.jasperserver.export.io.ZipStreamOutput;
import com.jaspersoft.jasperserver.export.service.ExportFailedException;
import com.jaspersoft.jasperserver.export.service.ImportExportService;
import com.jaspersoft.jasperserver.export.service.ImportFailedException;
import com.jaspersoft.jasperserver.export.util.CommandOut;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipException;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class ImportExportServiceImpl
implements ImportExportService,
ZipFileInputManager,
ApplicationContextAware {
    public static final String ROLES_PARAMETER = "roles";
    public static final String USERS_PARAMETER = "users";
    public static final String URIS_PARAMETER = "uris";
    public static final String URIS_OF_SCHEDULED_PARAMETER = "report-jobs";
    protected static final CommandOut log = CommandOut.getInstance();
    @Resource(name="messageSource")
    private MessageSource messageSource;
    private PathProcessorFactory pathProcessorFactory;
    private String propertyPathProcessorId = "pathProcessorId";
    private ApplicationContext applicationContext;

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void doImport(File input, Map<String, Boolean> importParams) throws ImportFailedException {
        Importer importer = this.getImporter();
        String processorId = this.pathProcessorFactory.getDefaultInputProcessor();
        PathProcessor processor = this.pathProcessorFactory.getProcessor(processorId);
        ImportTaskImpl task = new ImportTaskImpl();
        task.setExecutionContext((ExecutionContext)this.makeExecutionContext());
        task.setParameters(this.createImportParameters(importParams));
        task.setInput(new ZipFileInput(input, processor, (ZipFileInputManager)this));
        task.setApplicationContext(this.getApplicationContext());
        this.startImport(importer, task);
    }

    @Override
    public void doImport(InputStream input, Map<String, Boolean> importParams) throws ImportFailedException {
        File tempFile = null;
        try {
            tempFile = this.createTmpFile(input);
            log.debug("Upload finished. Temp file created at " + tempFile.getAbsolutePath());
            this.doImport(tempFile, importParams);
        }
        catch (IOException e) {
            throw new ImportFailedException(e.getMessage());
        }
        finally {
            if (tempFile != null) {
                if (tempFile.delete()) {
                    log.debug("Uploaded file was deleted from: " + tempFile.getAbsolutePath());
                } else {
                    log.debug("Can't delete temp dir from:" + tempFile.getAbsolutePath());
                }
            }
        }
    }

    @Override
    public void doExport(OutputStream output, Map<String, Boolean> exportParams, List<String> urisOfResources, List<String> urisOfScheduledJobs, List<String> rolesToExport, List<String> usersToExport) throws ExportFailedException {
        Exporter exporter = this.getExporter();
        ExportTaskImpl task = new ExportTaskImpl();
        task.setExecutionContext((ExecutionContext)this.makeExecutionContext());
        task.setParameters(this.createExportParameters(exportParams, urisOfResources, urisOfScheduledJobs, rolesToExport, usersToExport));
        String processorId = this.pathProcessorFactory.getDefaultOutputProcessor();
        PathProcessor pathProcessor = this.pathProcessorFactory.getProcessor(processorId);
        Properties properties = new Properties();
        properties.setProperty(this.propertyPathProcessorId, processorId);
        task.setOutput(new ZipStreamOutput(output, 9, pathProcessor, properties));
        this.startExport(exporter, task);
    }

    @Override
    public void updateInputProperties(ZipFileInput input, Properties properties) {
        String pathProcessorId = properties.getProperty(this.propertyPathProcessorId);
        if (pathProcessorId != null && !pathProcessorId.equals(this.pathProcessorFactory.getDefaultInputProcessor())) {
            PathProcessor processor = this.pathProcessorFactory.getProcessor(pathProcessorId);
            input.setPathProcessor(processor);
        }
    }

    protected void startImport(Importer importer, ImportTaskImpl task) throws ImportFailedException {
        try {
            log.info("About to start import process");
            importer.setTask(task);
            importer.performImport();
            log.info("Import process completed successfully");
        }
        catch (Exception e) {
            if (e.getCause() instanceof ZipException) {
                throw new ImportFailedException(this.localize("exception.remote.import.failed.zip.error"));
            }
            if (e instanceof NullPointerException) {
                throw new ImportFailedException(this.localize("exception.remote.import.failed.content.error"));
            }
            throw new ImportFailedException(MessageFormat.format(this.localize("exception.remote.import.failed"), e.getMessage()));
        }
    }

    protected void startExport(Exporter exporter, ExportTaskImpl task) throws ExportFailedException {
        try {
            log.info("About to start export process");
            exporter.setTask(task);
            exporter.performExport();
            log.info("Export process completed successfully");
        }
        catch (JSException e) {
            throw new ExportFailedException(e.getLocalizedMessage());
        }
    }

    private Parameters createExportParameters(Map<String, Boolean> exportParams, List<String> urisOfResources, List<String> urisOfScheduledJobs, List<String> rolesToExport, List<String> usersToExport) {
        ParametersImpl parameters = new ParametersImpl();
        this.processInputList(parameters, URIS_PARAMETER, urisOfResources);
        this.processInputList(parameters, URIS_OF_SCHEDULED_PARAMETER, urisOfScheduledJobs);
        this.processInputList(parameters, ROLES_PARAMETER, rolesToExport);
        this.processInputList(parameters, USERS_PARAMETER, usersToExport);
        this.processInputMap(parameters, exportParams);
        return parameters;
    }

    private Parameters createImportParameters(Map<String, Boolean> importParams) {
        ParametersImpl parameters = new ParametersImpl();
        this.processInputMap(parameters, importParams);
        return parameters;
    }

    private void processInputMap(Parameters parameters, Map<String, Boolean> map) {
        if (map != null) {
            for (String param : map.keySet()) {
                if (!map.get(param).booleanValue()) continue;
                parameters.addParameter(param);
            }
        }
    }

    private void processInputList(Parameters parameters, String parameter, List<String> list) {
        if (list != null) {
            if (list.size() > 0) {
                parameters.addParameterValues(parameter, list.toArray(new String[list.size()]));
            } else {
                parameters.addParameter(parameter);
            }
        }
    }

    private File createTmpFile(InputStream input) throws IOException {
        File tmp = File.createTempFile("tmp" + input.hashCode(), null);
        FileOutputStream fileStream = new FileOutputStream(tmp);
        byte[] buff = new byte[512];
        int read = input.read(buff);
        while (read > 0) {
            fileStream.write(buff, 0, read);
            read = input.read(buff);
        }
        fileStream.flush();
        fileStream.close();
        return tmp;
    }

    private ExecutionContextImpl makeExecutionContext() {
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setLocale(LocaleContextHolder.getLocale());
        context.getAttributes().add("PRIVILEGED_OPERATION");
        return context;
    }

    private String localize(String key) {
        return this.messageSource.getMessage(key, null, key, LocaleContextHolder.getLocale());
    }

    public abstract Exporter getExporter();

    public abstract Importer getImporter();

    public PathProcessorFactory getPathProcessorFactory() {
        return this.pathProcessorFactory;
    }

    public void setPathProcessorFactory(PathProcessorFactory pathProcessorFactory) {
        this.pathProcessorFactory = pathProcessorFactory;
    }

    public String getPropertyPathProcessorId() {
        return this.propertyPathProcessorId;
    }

    public void setPropertyPathProcessorId(String propertyPathProcessorId) {
        this.propertyPathProcessorId = propertyPathProcessorId;
    }
}

