/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataTypeValueClassResolver;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.types.DateTime;

public class DataTypeBean
extends ResourceBean {
    private byte type;
    private Integer maxLength;
    private Integer decimals;
    private String regularExpr;
    private Object minValue;
    private Object maxValue;
    private boolean strictMin;
    private boolean strictMax;

    @Override
    protected void additionalCopyFrom(Resource res, ResourceExportHandler referenceHandler) {
        DataType dt = (DataType)res;
        this.setType(dt.getType());
        this.setMaxLength(dt.getMaxLength());
        this.setDecimals(dt.getDecimals());
        this.setRegularExpr(dt.getRegularExpr());
        this.setMinValue(dt.getMinValue());
        this.setMaxValue(dt.getMaxValue());
        this.setStrictMin(dt.isStrictMin());
        this.setStrictMax(dt.isStrictMax());
    }

    @Override
    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        DataType dt = (DataType)res;
        dt.setType(this.getType());
        dt.setMaxLength(this.getMaxLength());
        dt.setDecimals(this.getDecimals());
        dt.setRegularExpr(this.getRegularExpr());
        dt.setMinValue(this.fixCastorAnyNode(this.getMinValue(), dt));
        dt.setMaxValue(this.fixCastorAnyNode(this.getMaxValue(), dt));
        dt.setStrictMin(this.isStrictMin());
        dt.setStrictMax(this.isStrictMax());
    }

    public Integer getDecimals() {
        return this.decimals;
    }

    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Object maxValue) {
        this.maxValue = maxValue;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Object minValue) {
        this.minValue = minValue;
    }

    public String getRegularExpr() {
        return this.regularExpr;
    }

    public void setRegularExpr(String regularExpr) {
        this.regularExpr = regularExpr;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public boolean isStrictMax() {
        return this.strictMax;
    }

    public void setStrictMax(boolean strictMax) {
        this.strictMax = strictMax;
    }

    public boolean isStrictMin() {
        return this.strictMin;
    }

    public void setStrictMin(boolean strictMin) {
        this.strictMin = strictMin;
    }

    private Comparable fixCastorAnyNode(Object value, DataType dt) {
        if (value instanceof AnyNode) {
            String stringValue = ((AnyNode)value).getStringValue();
            Class type = DataTypeValueClassResolver.getValueClass((DataType)dt);
            if (Time.class.equals((Object)type)) {
                value = this.convertSqlTime(stringValue);
            } else if (Timestamp.class.equals((Object)type)) {
                value = this.convertSqlTimestamp(stringValue);
            } else {
                throw new IllegalStateException("Cannot fix Castor " + (type != null ? "for class" + type.getSimpleName() : "for type " + dt.getType()));
            }
        }
        return (Comparable)value;
    }

    private Comparable convertSqlTime(String value) {
        if (value == null) {
            return null;
        }
        String str = value.toString();
        Time time = null;
        if (str.indexOf(58) == 2) {
            time = Time.valueOf(str);
        } else {
            try {
                Date date = new DateTime(str.trim()).toDate();
                time = new Time(date.getTime());
            }
            catch (ParseException px) {
                throw new IllegalStateException(px.getMessage());
            }
        }
        return time;
    }

    private Comparable convertSqlTimestamp(String value) {
        Timestamp timestamp = null;
        String str = value.toString();
        if (str.indexOf(84) == 10) {
            try {
                Date date = new DateTime(str.trim()).toDate();
                timestamp = new Timestamp(date.getTime());
            }
            catch (ParseException px) {
                throw new IllegalStateException(px.getMessage());
            }
        } else {
            timestamp = Timestamp.valueOf(str);
        }
        return timestamp;
    }
}

