/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.io.ImportInput;
import com.jaspersoft.jasperserver.export.io.ImportInputFactory;
import com.jaspersoft.jasperserver.export.io.PathProcessor;
import com.jaspersoft.jasperserver.export.io.PathProcessorFactory;
import com.jaspersoft.jasperserver.export.io.ZipFileInput;
import com.jaspersoft.jasperserver.export.io.ZipFileInputManager;
import java.util.Properties;

public class ZipFileInputFactory
implements ImportInputFactory,
ZipFileInputManager {
    private String inputZipParameter;
    private PathProcessorFactory pathProcessorFactory;
    private String propertyPathProcessorId;

    @Override
    public boolean matches(Parameters parameters) {
        return parameters.hasParameter(this.inputZipParameter);
    }

    @Override
    public ImportInput createInput(Parameters parameters) {
        String zipFile = parameters.getParameterValue(this.inputZipParameter);
        if (zipFile == null) {
            throw new JSException("No import ZIP file was specified.");
        }
        String processorId = this.pathProcessorFactory.getDefaultInputProcessor();
        PathProcessor processor = this.pathProcessorFactory.getProcessor(processorId);
        return new ZipFileInput(zipFile, processor, (ZipFileInputManager)this);
    }

    @Override
    public void updateInputProperties(ZipFileInput input, Properties properties) {
        String pathProcessorId = properties.getProperty(this.propertyPathProcessorId);
        if (pathProcessorId != null && !pathProcessorId.equals(this.pathProcessorFactory.getDefaultInputProcessor())) {
            PathProcessor processor = this.pathProcessorFactory.getProcessor(pathProcessorId);
            input.setPathProcessor(processor);
        }
    }

    public String getInputZipParameter() {
        return this.inputZipParameter;
    }

    public void setInputZipParameter(String inputDirParameter) {
        this.inputZipParameter = inputDirParameter;
    }

    public PathProcessorFactory getPathProcessorFactory() {
        return this.pathProcessorFactory;
    }

    public void setPathProcessorFactory(PathProcessorFactory pathProcessorFactory) {
        this.pathProcessorFactory = pathProcessorFactory;
    }

    public String getPropertyPathProcessorId() {
        return this.propertyPathProcessorId;
    }

    public void setPropertyPathProcessorId(String propertyPathProcessorId) {
        this.propertyPathProcessorId = propertyPathProcessorId;
    }
}

