/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.GroupingSetsList;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentLoader {
    private static final Comparator<Object> BOOLEAN_COMPARATOR;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void load(List<GroupingSet> groupingSets, RolapAggregationManager.PinSet pinnedSegments, List<StarPredicate> compoundPredicateList) {
        GroupingSetsList groupingSetsList = new GroupingSetsList(groupingSets);
        RolapStar.Column[] defaultColumns = groupingSetsList.getDefaultColumns();
        SqlStatement stmt = null;
        try {
            stmt = this.createExecuteSql(groupingSetsList, compoundPredicateList);
            int arity = defaultColumns.length;
            SortedSet<Comparable<?>>[] axisValueSets = this.getDistinctValueWorkspace(arity);
            boolean[] axisContainsNull = new boolean[arity];
            RowList rows = this.processData(stmt, axisContainsNull, axisValueSets, groupingSetsList);
            boolean sparse = this.setAxisDataAndDecideSparseUse(axisValueSets, axisContainsNull, groupingSetsList, rows);
            Map<BitKey, GroupingSetsList.Cohort> groupingDataSetsMap = this.createDataSetsForGroupingSets(groupingSetsList, sparse, rows.getTypes().subList(arity, rows.getTypes().size()));
            this.loadDataToDataSets(groupingSetsList, rows, groupingDataSetsMap);
            this.setDataToSegments(groupingSetsList, groupingDataSetsMap, pinnedSegments);
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.setFailOnStillLoadingSegments(groupingSetsList);
        }
    }

    void setFailOnStillLoadingSegments(GroupingSetsList groupingSetsList) {
        for (GroupingSet groupingset : groupingSetsList.getGroupingSets()) {
            for (Segment segment : groupingset.getSegments()) {
                segment.setFailIfStillLoading();
            }
        }
    }

    private void loadDataToDataSets(GroupingSetsList groupingSetsList, RowList rows, Map<BitKey, GroupingSetsList.Cohort> groupingDataSetMap) {
        int arity = groupingSetsList.getDefaultColumns().length;
        Aggregation.Axis[] axes = groupingSetsList.getDefaultAxes();
        int segmentLength = groupingSetsList.getDefaultSegments().size();
        List<SqlStatement.Type> types = rows.getTypes();
        boolean useGroupingSet = groupingSetsList.useGroupingSets();
        rows.first();
        while (rows.next()) {
            int j;
            GroupingSetsList.Cohort cohort;
            BitKey groupingBitKey;
            if (useGroupingSet) {
                groupingBitKey = (BitKey)rows.getObject(groupingSetsList.getGroupingBitKeyIndex());
                cohort = groupingDataSetMap.get(groupingBitKey);
            } else {
                groupingBitKey = null;
                cohort = groupingDataSetMap.get(BitKey.EMPTY);
            }
            int[] pos = cohort.pos;
            int k = 0;
            block4: for (j = 0; j < arity; ++j) {
                SqlStatement.Type type = types.get(j);
                switch (type) {
                    case OBJECT: 
                    case INT: 
                    case DOUBLE: {
                        Object o = rows.getObject(j);
                        if (useGroupingSet && (o == null || o == RolapUtil.sqlNullValue) && groupingBitKey.get(groupingSetsList.findGroupingFunctionIndex(j))) continue block4;
                        Aggregation.Axis axis = axes[j];
                        if (o == null) {
                            o = RolapUtil.sqlNullValue;
                        }
                        int offset = axis.getOffset(o);
                        pos[k++] = offset;
                        continue block4;
                    }
                    default: {
                        throw Util.unexpected(type);
                    }
                }
            }
            for (j = 0; j < segmentLength; ++j) {
                cohort.segmentDatasetList.get(j).populateFrom(pos, rows, arity + j);
            }
        }
    }

    private boolean setAxisDataAndDecideSparseUse(SortedSet<Comparable<?>>[] axisValueSets, boolean[] axisContainsNull, GroupingSetsList groupingSetsList, RowList rows) {
        Aggregation.Axis[] axes = groupingSetsList.getDefaultAxes();
        RolapStar.Column[] allColumns = groupingSetsList.getDefaultColumns();
        boolean sparse = false;
        int n = 1;
        for (int i = 0; i < axes.length; ++i) {
            Aggregation.Axis axis = axes[i];
            SortedSet<Comparable<?>> valueSet = axisValueSets[i];
            int size = axis.loadKeys(valueSet, axisContainsNull[i]);
            this.setAxisDataToGroupableList(groupingSetsList, valueSet, axisContainsNull[i], allColumns[i]);
            int previous = n;
            if ((n *= size) >= previous && n >= size) continue;
            n = Integer.MAX_VALUE;
            sparse = true;
        }
        return this.useSparse(sparse, n, rows);
    }

    boolean useSparse(boolean sparse, int n, RowList rows) {
        sparse = sparse || SegmentLoader.useSparse(n, rows.size());
        return sparse;
    }

    private void setDataToSegments(GroupingSetsList groupingSetsList, Map<BitKey, GroupingSetsList.Cohort> datasetsMap, RolapAggregationManager.PinSet pinnedSegments) {
        List<GroupingSet> groupingSets = groupingSetsList.getGroupingSets();
        for (int i = 0; i < groupingSets.size(); ++i) {
            List<Segment> groupedSegments = groupingSets.get(i).getSegments();
            GroupingSetsList.Cohort cohort = datasetsMap.get(groupingSetsList.getRollupColumnsBitKeyList().get(i));
            for (int j = 0; j < groupedSegments.size(); ++j) {
                Segment groupedSegment = groupedSegments.get(j);
                SegmentDataset segmentDataset = cohort.segmentDatasetList.get(j);
                groupedSegment.setData(segmentDataset, pinnedSegments);
            }
        }
    }

    private Map<BitKey, GroupingSetsList.Cohort> createDataSetsForGroupingSets(GroupingSetsList groupingSetsList, boolean sparse, List<SqlStatement.Type> types) {
        if (!groupingSetsList.useGroupingSets()) {
            GroupingSetsList.Cohort datasets = this.createDataSets(sparse, groupingSetsList.getDefaultSegments(), groupingSetsList.getDefaultAxes(), types);
            return Collections.singletonMap(BitKey.EMPTY, datasets);
        }
        HashMap<BitKey, GroupingSetsList.Cohort> datasetsMap = new HashMap<BitKey, GroupingSetsList.Cohort>();
        List<GroupingSet> groupingSets = groupingSetsList.getGroupingSets();
        List<BitKey> groupingColumnsBitKeyList = groupingSetsList.getRollupColumnsBitKeyList();
        for (int i = 0; i < groupingSets.size(); ++i) {
            GroupingSet groupingSet = groupingSets.get(i);
            GroupingSetsList.Cohort cohort = this.createDataSets(sparse, groupingSet.getSegments(), groupingSet.getAxes(), types);
            datasetsMap.put(groupingColumnsBitKeyList.get(i), cohort);
        }
        return datasetsMap;
    }

    private int calculateMaxDataSize(Aggregation.Axis[] axes) {
        int n = 1;
        for (Aggregation.Axis axis : axes) {
            n *= axis.getKeys().length;
        }
        return n;
    }

    private GroupingSetsList.Cohort createDataSets(boolean sparse, List<Segment> segments, Aggregation.Axis[] axes, List<SqlStatement.Type> types) {
        ArrayList<SegmentDataset> datasets = new ArrayList<SegmentDataset>(segments.size());
        int n = sparse ? 0 : this.calculateMaxDataSize(axes);
        for (int i = 0; i < segments.size(); ++i) {
            Segment segment = segments.get(i);
            datasets.add(segment.createDataset(sparse, types.get(i), n));
        }
        return new GroupingSetsList.Cohort(datasets, axes.length);
    }

    private void setAxisDataToGroupableList(GroupingSetsList groupingSetsList, SortedSet<Comparable<?>> valueSet, boolean axisContainsNull, RolapStar.Column column) {
        for (GroupingSet groupingSet : groupingSetsList.getRollupGroupingSets()) {
            RolapStar.Column[] columns = groupingSet.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].equals(column)) continue;
                groupingSet.getAxes()[i].loadKeys(valueSet, axisContainsNull);
            }
        }
    }

    SqlStatement createExecuteSql(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
        RolapStar star = groupingSetsList.getStar();
        String sql = AggregationManager.instance().generateSql(groupingSetsList, compoundPredicateList);
        return RolapUtil.executeQuery(star.getDataSource(), sql, "Segment.load", "Error while loading segment");
    }

    RowList processData(SqlStatement stmt, boolean[] axisContainsNull, SortedSet<Comparable<?>>[] axisValueSets, GroupingSetsList groupingSetsList) throws SQLException {
        List<SqlStatement.Type> processedTypes;
        List<Segment> segments = groupingSetsList.getDefaultSegments();
        int measureCount = segments.size();
        ResultSet rawRows = this.loadData(stmt, groupingSetsList);
        List<SqlStatement.Type> types = stmt == null ? Collections.nCopies(rawRows.getMetaData().getColumnCount(), SqlStatement.Type.OBJECT) : stmt.guessTypes();
        int arity = axisValueSets.length;
        int groupingColumnStartIndex = arity + measureCount;
        if (groupingSetsList.useGroupingSets()) {
            processedTypes = new ArrayList<SqlStatement.Type>(types.subList(0, groupingColumnStartIndex));
            processedTypes.add(SqlStatement.Type.OBJECT);
        } else {
            processedTypes = types;
        }
        RowList processedRows = new RowList(processedTypes, 100);
        while (rawRows.next()) {
            processedRows.createRow();
            int columnIndex = 0;
            int axisIndex = 0;
            while (axisIndex < arity) {
                SqlStatement.Type type = types.get(columnIndex);
                switch (type) {
                    case OBJECT: {
                        Object o = rawRows.getObject(columnIndex + 1);
                        if (o == null) {
                            o = RolapUtil.sqlNullValue;
                            if (!groupingSetsList.useGroupingSets() || !this.isAggregateNull(rawRows, groupingColumnStartIndex, groupingSetsList, axisIndex)) {
                                axisContainsNull[axisIndex] = true;
                            }
                        } else {
                            axisValueSets[axisIndex].add(Aggregation.Axis.wrap(o));
                        }
                        processedRows.setObject(columnIndex, o);
                        break;
                    }
                    case INT: {
                        int intValue = rawRows.getInt(columnIndex + 1);
                        if (intValue == 0 && rawRows.wasNull()) {
                            if (!groupingSetsList.useGroupingSets() || !this.isAggregateNull(rawRows, groupingColumnStartIndex, groupingSetsList, axisIndex)) {
                                axisContainsNull[axisIndex] = true;
                            }
                            processedRows.setNull(columnIndex, true);
                            break;
                        }
                        axisValueSets[axisIndex].add(Integer.valueOf(intValue));
                        processedRows.setInt(columnIndex, intValue);
                        break;
                    }
                    case DOUBLE: {
                        double doubleValue = rawRows.getDouble(columnIndex + 1);
                        if (!(doubleValue != 0.0 || !rawRows.wasNull() || groupingSetsList.useGroupingSets() && this.isAggregateNull(rawRows, groupingColumnStartIndex, groupingSetsList, axisIndex))) {
                            axisContainsNull[axisIndex] = true;
                        }
                        axisValueSets[axisIndex].add(Double.valueOf(doubleValue));
                        processedRows.setDouble(columnIndex, doubleValue);
                        break;
                    }
                    default: {
                        throw Util.unexpected(type);
                    }
                }
                ++axisIndex;
                ++columnIndex;
            }
            boolean[] numeric = new boolean[measureCount];
            int k = 0;
            for (Segment segment : segments) {
                numeric[k++] = segment.measure.getDatatype().isNumeric();
            }
            int i = 0;
            while (i < measureCount) {
                SqlStatement.Type type = types.get(columnIndex);
                switch (type) {
                    case OBJECT: {
                        Object o = rawRows.getObject(columnIndex + 1);
                        if (o == null) {
                            o = Util.nullValue;
                        } else if (numeric[i] && !(o instanceof Double)) {
                            o = o instanceof Number ? Double.valueOf(((Number)o).doubleValue()) : (o instanceof byte[] ? Double.valueOf(Double.parseDouble(new String((byte[])o))) : Double.valueOf(Double.parseDouble(o.toString())));
                        }
                        processedRows.setObject(columnIndex, o);
                        break;
                    }
                    case INT: {
                        int intValue = rawRows.getInt(columnIndex + 1);
                        processedRows.setInt(columnIndex, intValue);
                        if (intValue != 0 || !rawRows.wasNull()) break;
                        processedRows.setNull(columnIndex, true);
                        break;
                    }
                    case DOUBLE: {
                        double doubleValue = rawRows.getDouble(columnIndex + 1);
                        processedRows.setDouble(columnIndex, doubleValue);
                        if (doubleValue != 0.0 || !rawRows.wasNull()) break;
                        processedRows.setNull(columnIndex, true);
                        break;
                    }
                    default: {
                        throw Util.unexpected(type);
                    }
                }
                ++i;
                ++columnIndex;
            }
            if (!groupingSetsList.useGroupingSets()) continue;
            processedRows.setObject(columnIndex, this.getRollupBitKey(groupingSetsList.getRollupColumns().size(), rawRows, columnIndex));
        }
        return processedRows;
    }

    BitKey getRollupBitKey(int arity, ResultSet rowList, int k) throws SQLException {
        BitKey groupingBitKey = BitKey.Factory.makeBitKey(arity);
        for (int i = 0; i < arity; ++i) {
            int o = rowList.getInt(k + i + 1);
            if (o != 1) continue;
            groupingBitKey.set(i);
        }
        return groupingBitKey;
    }

    private boolean isAggregateNull(ResultSet rowList, int groupingColumnStartIndex, GroupingSetsList groupingSetsList, int axisIndex) throws SQLException {
        int groupingFunctionIndex = groupingSetsList.findGroupingFunctionIndex(axisIndex);
        if (groupingFunctionIndex == -1) {
            return false;
        }
        return rowList.getInt(groupingColumnStartIndex + groupingFunctionIndex + 1) == 1;
    }

    ResultSet loadData(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
        int arity = groupingSetsList.getDefaultColumns().length;
        int measureCount = groupingSetsList.getDefaultSegments().size();
        int groupingFunctionsCount = groupingSetsList.getRollupColumns().size();
        List<SqlStatement.Type> types = stmt.guessTypes();
        if (!$assertionsDisabled && arity + measureCount + groupingFunctionsCount != types.size()) {
            throw new AssertionError();
        }
        return stmt.getResultSet();
    }

    RowList loadData2(SqlStatement stmt, GroupingSetsList groupingSetsList) throws SQLException {
        int arity = groupingSetsList.getDefaultColumns().length;
        int measureCount = groupingSetsList.getDefaultSegments().size();
        int groupingFunctionsCount = groupingSetsList.getRollupColumns().size();
        List<SqlStatement.Type> types = stmt.guessTypes();
        if (!$assertionsDisabled && arity + measureCount + groupingFunctionsCount != types.size()) {
            throw new AssertionError();
        }
        RowList rows = new RowList(types, 100);
        ResultSet resultSet = stmt.getResultSet();
        while (resultSet.next()) {
            ++stmt.rowCount;
            rows.createRow(resultSet);
        }
        return rows;
    }

    SortedSet<Comparable<?>>[] getDistinctValueWorkspace(int arity) {
        SortedSet[] axisValueSets = new SortedSet[arity];
        for (int i = 0; i < axisValueSets.length; ++i) {
            axisValueSets[i] = Util.PreJdk15 ? new TreeSet<Object>(BOOLEAN_COMPARATOR) : new TreeSet();
        }
        return axisValueSets;
    }

    private static boolean useSparse(double possibleCount, double actualCount) {
        boolean sparse;
        int countThreshold;
        MondrianProperties properties = MondrianProperties.instance();
        double densityThreshold = properties.SparseSegmentDensityThreshold.get();
        if (densityThreshold < 0.0) {
            densityThreshold = 0.0;
        }
        if (densityThreshold > 1.0) {
            densityThreshold = 1.0;
        }
        if ((countThreshold = properties.SparseSegmentCountThreshold.get()) < 0) {
            countThreshold = 0;
        }
        boolean bl = sparse = (possibleCount - (double)countThreshold) * densityThreshold > actualCount;
        if (possibleCount < (double)countThreshold && !$assertionsDisabled && sparse) {
            throw new AssertionError((Object)("Should never use sparse if count is less than threshold, possibleCount=" + possibleCount + ", actualCount=" + actualCount + ", countThreshold=" + countThreshold + ", densityThreshold=" + densityThreshold));
        }
        if (possibleCount == actualCount && !$assertionsDisabled && sparse) {
            throw new AssertionError((Object)("Should never use sparse if result is 100% dense: possibleCount=" + possibleCount + ", actualCount=" + actualCount + ", countThreshold=" + countThreshold + ", densityThreshold=" + densityThreshold));
        }
        return sparse;
    }

    static {
        boolean bl = $assertionsDisabled = !SegmentLoader.class.desiredAssertionStatus();
        if (Util.PreJdk15) {
            if (!$assertionsDisabled && Comparable.class.isAssignableFrom(Boolean.class)) {
                throw new AssertionError();
            }
            BOOLEAN_COMPARATOR = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof Boolean) {
                        boolean b1 = (Boolean)o1;
                        if (o2 instanceof Boolean) {
                            boolean b2 = (Boolean)o2;
                            return b1 == b2 ? 0 : (b1 ? 1 : -1);
                        }
                        return -1;
                    }
                    return ((Comparable)o1).compareTo(o2);
                }
            };
        } else {
            if (!$assertionsDisabled && !Comparable.class.isAssignableFrom(Boolean.class)) {
                throw new AssertionError();
            }
            BOOLEAN_COMPARATOR = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RowList {
        private final Column[] columns;
        private int rowCount = 0;
        private int capacity = 0;
        private int currentRow = -1;

        RowList(List<SqlStatement.Type> types) {
            this(types, 100);
        }

        RowList(List<SqlStatement.Type> types, int capacity) {
            this.columns = new Column[types.size()];
            this.capacity = capacity;
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i] = Column.forType(i, types.get(i), capacity);
            }
        }

        void createRow() {
            this.currentRow = this.rowCount++;
            if (this.rowCount > this.capacity) {
                this.capacity *= 3;
                for (Column column : this.columns) {
                    column.resize(this.capacity);
                }
            }
        }

        void setObject(int column, Object value) {
            this.columns[column].setObject(this.currentRow, value);
        }

        void setDouble(int column, double value) {
            this.columns[column].setDouble(this.currentRow, value);
        }

        void setInt(int column, int value) {
            this.columns[column].setInt(this.currentRow, value);
        }

        public int size() {
            return this.rowCount;
        }

        public void createRow(ResultSet resultSet) throws SQLException {
            this.createRow();
            for (Column column : this.columns) {
                column.populateFrom(this.currentRow, resultSet);
            }
        }

        public List<SqlStatement.Type> getTypes() {
            return new AbstractList<SqlStatement.Type>(){

                @Override
                public SqlStatement.Type get(int index) {
                    return ((RowList)RowList.this).columns[index].type;
                }

                @Override
                public int size() {
                    return RowList.this.columns.length;
                }
            };
        }

        public void first() {
            this.currentRow = -1;
        }

        public void last() {
            this.currentRow = this.rowCount;
        }

        public boolean next() {
            if (this.currentRow < this.rowCount - 1) {
                ++this.currentRow;
                return true;
            }
            return false;
        }

        public boolean previous() {
            if (this.currentRow > 0) {
                --this.currentRow;
                return true;
            }
            return false;
        }

        public Object getObject(int columnIndex) {
            return this.columns[columnIndex].getObject(this.currentRow);
        }

        public int getInt(int columnIndex) {
            return this.columns[columnIndex].getInt(this.currentRow);
        }

        public double getDouble(int columnIndex) {
            return this.columns[columnIndex].getDouble(this.currentRow);
        }

        public boolean isNull(int columnIndex) {
            return this.columns[columnIndex].isNull(this.currentRow);
        }

        public void setNull(int columnIndex, boolean b) {
            this.columns[columnIndex].setNull(this.currentRow, b);
        }

        public static interface Handler {
        }

        static class DoubleColumn
        extends NativeColumn {
            private double[] doubles;

            DoubleColumn(int ordinal, SqlStatement.Type type, int size) {
                super(ordinal, type);
                this.doubles = new double[size];
            }

            public void resize(int newSize) {
                this.doubles = Util.copyOf(this.doubles, newSize);
            }

            public void populateFrom(int row, ResultSet resultSet) throws SQLException {
                this.doubles[row] = resultSet.getDouble(this.ordinal + 1);
                double d = this.doubles[row];
                if (d == 0.0) {
                    this.getNullIndicators().set(row, resultSet.wasNull());
                }
            }

            public void setDouble(int row, double value) {
                this.doubles[row] = value;
            }

            public double getDouble(int row) {
                return this.doubles[row];
            }

            protected int getCapacity() {
                return this.doubles.length;
            }

            public boolean isNull(int row) {
                return this.doubles[row] == 0.0 && this.nullIndicators != null && this.nullIndicators.get(row);
            }

            public Double getObject(int row) {
                return this.isNull(row) ? null : Double.valueOf(this.doubles[row]);
            }
        }

        static class IntColumn
        extends NativeColumn {
            private int[] ints;

            IntColumn(int ordinal, SqlStatement.Type type, int size) {
                super(ordinal, type);
                this.ints = new int[size];
            }

            public void resize(int newSize) {
                this.ints = Util.copyOf(this.ints, newSize);
            }

            public void populateFrom(int row, ResultSet resultSet) throws SQLException {
                this.ints[row] = resultSet.getInt(this.ordinal + 1);
                int i = this.ints[row];
                if (i == 0) {
                    this.getNullIndicators().set(row, resultSet.wasNull());
                }
            }

            public void setInt(int row, int value) {
                this.ints[row] = value;
            }

            public int getInt(int row) {
                return this.ints[row];
            }

            public boolean isNull(int row) {
                return this.ints[row] == 0 && this.nullIndicators != null && this.nullIndicators.get(row);
            }

            protected int getCapacity() {
                return this.ints.length;
            }

            public Integer getObject(int row) {
                return this.isNull(row) ? null : Integer.valueOf(this.ints[row]);
            }
        }

        static abstract class NativeColumn
        extends Column {
            protected BitSet nullIndicators;

            NativeColumn(int ordinal, SqlStatement.Type type) {
                super(ordinal, type);
            }

            public void setNull(int row, boolean b) {
                this.getNullIndicators().set(row, b);
            }

            protected BitSet getNullIndicators() {
                if (this.nullIndicators == null) {
                    this.nullIndicators = new BitSet(this.getCapacity());
                }
                return this.nullIndicators;
            }
        }

        static class ObjectColumn
        extends Column {
            private Object[] objects;

            ObjectColumn(int ordinal, SqlStatement.Type type, int size) {
                super(ordinal, type);
                this.objects = new Object[size];
            }

            protected int getCapacity() {
                return this.objects.length;
            }

            public boolean isNull(int row) {
                return this.objects[row] == null;
            }

            public void resize(int newSize) {
                this.objects = Util.copyOf(this.objects, newSize);
            }

            public void populateFrom(int row, ResultSet resultSet) throws SQLException {
                this.objects[row] = resultSet.getObject(this.ordinal + 1);
            }

            public void setObject(int row, Object value) {
                this.objects[row] = value;
            }

            public Object getObject(int row) {
                return this.objects[row];
            }
        }

        static abstract class Column {
            final int ordinal;
            final SqlStatement.Type type;

            protected Column(int ordinal, SqlStatement.Type type) {
                this.ordinal = ordinal;
                this.type = type;
            }

            static Column forType(int ordinal, SqlStatement.Type type, int capacity) {
                switch (type) {
                    case OBJECT: {
                        return new ObjectColumn(ordinal, type, capacity);
                    }
                    case INT: {
                        return new IntColumn(ordinal, type, capacity);
                    }
                    case DOUBLE: {
                        return new DoubleColumn(ordinal, type, capacity);
                    }
                }
                throw Util.unexpected(type);
            }

            public abstract void resize(int var1);

            public void setObject(int row, Object value) {
                throw new UnsupportedOperationException();
            }

            public void setDouble(int row, double value) {
                throw new UnsupportedOperationException();
            }

            public void setInt(int row, int value) {
                throw new UnsupportedOperationException();
            }

            public void setNull(int row, boolean b) {
                throw new UnsupportedOperationException();
            }

            public abstract void populateFrom(int var1, ResultSet var2) throws SQLException;

            public Object getObject(int row) {
                throw new UnsupportedOperationException();
            }

            public int getInt(int row) {
                throw new UnsupportedOperationException();
            }

            public double getDouble(int row) {
                throw new UnsupportedOperationException();
            }

            protected abstract int getCapacity();

            public abstract boolean isNull(int var1);
        }
    }
}

