/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.HighCardSqlTupleReader;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.spi.Dialect;
import mondrian.util.CreationException;
import mondrian.util.ObjectFactory;
import org.eigenbase.util.property.StringProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SqlMemberSource
implements MemberReader,
TupleReader.MemberBuilder {
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private final RolapHierarchy hierarchy;
    private final DataSource dataSource;
    private MemberCache cache;
    private int lastOrdinal = 0;
    private boolean assignOrderKeys;
    private Map<Object, Object> valuePool;

    SqlMemberSource(RolapHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.dataSource = hierarchy.getRolapSchema().getInternalConnection().getDataSource();
        this.assignOrderKeys = MondrianProperties.instance().CompareSiblingsByOrderKey.get();
        this.valuePool = ValuePoolFactoryFactory.getValuePoolFactory().create(this);
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean setCache(MemberCache cache) {
        this.cache = cache;
        return true;
    }

    @Override
    public int getMemberCount() {
        RolapLevel[] levels = (RolapLevel[])this.hierarchy.getLevels();
        int count = 0;
        for (RolapLevel level : levels) {
            count += this.getLevelMemberCount(level);
        }
        return count;
    }

    @Override
    public RolapMember substitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember desubstitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember lookupMember(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLevelMemberCount(RolapLevel level) {
        if (level.isAll()) {
            return 1;
        }
        return this.getMemberCount(level, this.dataSource);
    }

    private int getMemberCount(RolapLevel level, DataSource dataSource) {
        boolean[] mustCount = new boolean[1];
        String sql = this.makeLevelMemberCountSql(level, dataSource, mustCount);
        SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, "SqlMemberSource.getLevelMemberCount", "while counting members of level '" + level);
        try {
            int count;
            ResultSet resultSet = stmt.getResultSet();
            if (!mustCount[0]) {
                Util.assertTrue(resultSet.next());
                ++stmt.rowCount;
                count = resultSet.getInt(1);
            } else {
                ResultSetMetaData rmd = resultSet.getMetaData();
                int nColumns = rmd.getColumnCount();
                String[] colStrings = new String[nColumns];
                count = 0;
                while (resultSet.next()) {
                    ++stmt.rowCount;
                    boolean isEqual = true;
                    for (int i = 0; i < nColumns; ++i) {
                        String colStr = resultSet.getString(i + 1);
                        if (!colStr.equals(colStrings[i])) {
                            isEqual = false;
                        }
                        colStrings[i] = colStr;
                    }
                    if (isEqual) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    private String makeLevelMemberCountSql(RolapLevel level, DataSource dataSource, boolean[] mustCount) {
        RolapLevel[] levels;
        mustCount[0] = false;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, "while generating query to count members in level " + level);
        int levelDepth = level.getDepth();
        if (levelDepth == (levels = (RolapLevel[])this.hierarchy.getLevels()).length) {
            sqlQuery.addSelect("count(*)");
            this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
            return sqlQuery.toString();
        }
        if (!sqlQuery.getDialect().allowsFromQuery()) {
            String columnList = "";
            int columnCount = 0;
            for (int i = levelDepth; i >= 0; --i) {
                RolapLevel level2 = levels[i];
                if (level2.isAll()) continue;
                if (columnCount > 0) {
                    if (sqlQuery.getDialect().allowsCompoundCountDistinct()) {
                        columnList = columnList + ", ";
                    } else {
                        mustCount[0] = true;
                    }
                }
                this.hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
                String keyExp = level2.getKeyExp().getExpression(sqlQuery);
                if (columnCount > 0 && !sqlQuery.getDialect().allowsCompoundCountDistinct() && sqlQuery.getDialect().getDatabaseProduct() == Dialect.DatabaseProduct.SYBASE) {
                    keyExp = "convert(varchar, " + columnList + ")";
                }
                columnList = columnList + keyExp;
                if (level2.isUnique()) break;
                ++columnCount;
            }
            if (mustCount[0]) {
                sqlQuery.addSelect(columnList);
                sqlQuery.addOrderBy(columnList, true, false, true);
            } else {
                sqlQuery.addSelect("count(DISTINCT " + columnList + ")");
            }
            return sqlQuery.toString();
        }
        sqlQuery.setDistinct(true);
        for (int i = levelDepth; i >= 0; --i) {
            RolapLevel level2 = levels[i];
            if (level2.isAll()) continue;
            this.hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
            sqlQuery.addSelect(level2.getKeyExp().getExpression(sqlQuery));
            if (level2.isUnique()) break;
        }
        SqlQuery outerQuery = SqlQuery.newQuery(dataSource, "while generating query to count members in level " + level);
        outerQuery.addSelect("count(*)");
        boolean failIfExists = true;
        outerQuery.addFrom(sqlQuery, "init", failIfExists);
        return outerQuery.toString();
    }

    @Override
    public List<RolapMember> getMembers() {
        return this.getMembers(this.dataSource);
    }

    private List<RolapMember> getMembers(DataSource dataSource) {
        String sql = this.makeKeysSql(dataSource);
        RolapLevel[] levels = (RolapLevel[])this.hierarchy.getLevels();
        SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, "SqlMemberSource.getMembers", "while building member cache");
        try {
            List<SqlStatement.Accessor> accessors = stmt.getAccessors();
            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
            HashMap<MemberKey, RolapMember> map = new HashMap<MemberKey, RolapMember>();
            RolapMember root = null;
            if (this.hierarchy.hasAll()) {
                root = this.hierarchy.getAllMember();
                list.add(root);
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            ResultSet resultSet = stmt.getResultSet();
            while (resultSet.next()) {
                ++stmt.rowCount;
                if (limit > 0 && limit < stmt.rowCount) {
                    throw stmt.handle(MondrianResource.instance().MemberFetchLimitExceeded.ex(limit));
                }
                int column = 0;
                RolapMember member = root;
                for (RolapLevel level : levels) {
                    RolapProperty[] properties;
                    RolapMember parent;
                    MemberKey key;
                    if (level.isAll()) continue;
                    Object value = accessors.get(column).get();
                    if (value == null) {
                        value = RolapUtil.sqlNullValue;
                    }
                    if ((member = (RolapMember)map.get(key = new MemberKey(parent = member, value))) == null) {
                        RolapMemberBase memberBase = new RolapMemberBase(parent, level, value);
                        memberBase.setOrdinal(this.lastOrdinal++);
                        member = memberBase;
                        if (value == RolapUtil.sqlNullValue) {
                            this.addAsOldestSibling(list, member);
                        } else {
                            list.add(member);
                        }
                        map.put(key, member);
                    }
                    ++column;
                    if (!level.getOrdinalExp().equals((Object)level.getKeyExp())) {
                        if (this.assignOrderKeys) {
                            Object orderKey = accessors.get(column).get();
                            this.setOrderKey((RolapMemberBase)member, orderKey);
                        }
                        ++column;
                    }
                    for (RolapProperty property : properties = level.getProperties()) {
                        member.setProperty(property.getName(), accessors.get(column).get());
                        ++column;
                    }
                }
            }
            ArrayList<RolapMember> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    private void setOrderKey(RolapMemberBase member, Object orderKey) {
        if (orderKey != null && !(orderKey instanceof Comparable)) {
            orderKey = orderKey.toString();
        }
        member.setOrderKey((Comparable)orderKey);
    }

    private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
        RolapMember sibling;
        int i = list.size();
        while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
        }
        list.add(i + 1, member);
    }

    private String makeKeysSql(DataSource dataSource) {
        RolapLevel[] levels;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, "while generating query to retrieve members of " + this.hierarchy);
        for (RolapLevel level : levels = (RolapLevel[])this.hierarchy.getLevels()) {
            RolapProperty[] properties;
            if (level.isAll()) continue;
            MondrianDef.Expression exp = level.getKeyExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String expString = exp.getExpression(sqlQuery);
            sqlQuery.addSelectGroupBy(expString);
            exp = level.getOrdinalExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            expString = exp.getExpression(sqlQuery);
            sqlQuery.addOrderBy(expString, true, false, true);
            if (!exp.equals((Object)level.getKeyExp())) {
                sqlQuery.addSelect(expString);
            }
            for (RolapProperty property : properties = level.getProperties()) {
                exp = property.getExp();
                this.hierarchy.addToFrom(sqlQuery, exp);
                expString = exp.getExpression(sqlQuery);
                String alias = sqlQuery.addSelect(expString);
                if (sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue()) continue;
                sqlQuery.addGroupBy(expString, alias);
            }
        }
        return sqlQuery.toString();
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, startOrdinal, endOrdinal, constraint);
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
        if (level.isAll()) {
            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
            list.add(this.hierarchy.getAllMember());
            return list;
        }
        return this.getMembersInLevel(level, constraint);
    }

    private List<RolapMember> getMembersInLevel(RolapLevel level, TupleConstraint constraint) {
        SqlTupleReader tupleReader = level.getDimension().isHighCardinality() ? new HighCardSqlTupleReader(constraint) : new SqlTupleReader(constraint);
        tupleReader.addLevelMembers(level, this, null);
        final List<RolapMember[]> tupleList = tupleReader.readTuples(this.dataSource, null, null);
        return new AbstractList<RolapMember>(){

            @Override
            public RolapMember get(int index) {
                return ((RolapMember[])tupleList.get(index))[0];
            }

            @Override
            public int size() {
                return tupleList.size();
            }

            public RolapMember[] toArray() {
                ArrayList<RolapMember> l = new ArrayList<RolapMember>();
                for (RolapMember[] tuple : tupleList) {
                    l.add(tuple[0]);
                }
                return l.toArray(new RolapMember[l.size()]);
            }

            @Override
            public <T> T[] toArray(T[] pattern) {
                return this.toArray();
            }

            @Override
            public Iterator<RolapMember> iterator() {
                final Iterator it = tupleList.iterator();
                return new Iterator<RolapMember>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public RolapMember next() {
                        return ((RolapMember[])it.next())[0];
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }
        };
    }

    @Override
    public MemberCache getMemberCache() {
        return this.cache;
    }

    @Override
    public Object getMemberCacheLock() {
        return this.cache;
    }

    @Override
    public List<RolapMember> getRootMembers() {
        return this.getMembersInLevel((RolapLevel)this.hierarchy.getLevels()[0], 0, Integer.MAX_VALUE);
    }

    String makeChildMemberSql(RolapMember member, DataSource dataSource, MemberChildrenConstraint constraint) {
        RolapProperty[] properties;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, "while generating query to retrieve children of member " + member);
        AggStar aggStar = SqlMemberSource.chooseAggStar(constraint, member);
        constraint.addMemberConstraint(sqlQuery, null, aggStar, member);
        RolapLevel level = (RolapLevel)member.getLevel().getChildLevel();
        boolean levelCollapsed = aggStar != null && SqlMemberSource.isLevelCollapsed(aggStar, (RolapCubeLevel)level);
        boolean multipleCols = SqlMemberSource.levelContainsMultipleColumns(level);
        if (levelCollapsed && !multipleCols) {
            RolapStar.Column starColumn = ((RolapCubeLevel)level).getStarKeyColumn();
            int bitPos = starColumn.getBitPosition();
            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
            String q = aggColumn.generateExprString(sqlQuery);
            sqlQuery.addSelectGroupBy(q);
            sqlQuery.addOrderBy(q, true, false, true);
            aggColumn.getTable().addToFrom(sqlQuery, false, true);
            return sqlQuery.toString();
        }
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String q = level.getKeyExp().getExpression(sqlQuery);
        sqlQuery.addSelectGroupBy(q);
        constraint.addLevelConstraint(sqlQuery, null, aggStar, level);
        if (levelCollapsed) {
            RolapStar.Column starColumn = ((RolapCubeLevel)level).getStarKeyColumn();
            int bitPos = starColumn.getBitPosition();
            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
            RolapStar.Condition condition = new RolapStar.Condition(level.getKeyExp(), aggColumn.getExpression());
            sqlQuery.addWhere(condition.toString(sqlQuery));
            this.hierarchy.addToFromInverse(sqlQuery, level.getKeyExp());
            boolean isUnique = level.isUnique();
            for (RolapCubeLevel parentLevel = (RolapCubeLevel)level.getParentLevel(); parentLevel != null && !parentLevel.isAll() && !isUnique; parentLevel = parentLevel.getParentLevel()) {
                this.hierarchy.addToFromInverse(sqlQuery, parentLevel.getKeyExp());
                starColumn = parentLevel.getStarKeyColumn();
                bitPos = starColumn.getBitPosition();
                aggColumn = aggStar.lookupColumn(bitPos);
                condition = new RolapStar.Condition(parentLevel.getKeyExp(), aggColumn.getExpression());
                sqlQuery.addWhere(condition.toString(sqlQuery));
            }
        }
        if (level.hasCaptionColumn()) {
            MondrianDef.Expression captionExp = level.getCaptionExp();
            if (!levelCollapsed) {
                this.hierarchy.addToFrom(sqlQuery, captionExp);
            }
            String captionSql = captionExp.getExpression(sqlQuery);
            sqlQuery.addSelectGroupBy(captionSql);
        }
        if (!levelCollapsed) {
            this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        }
        String orderBy = level.getOrdinalExp().getExpression(sqlQuery);
        sqlQuery.addOrderBy(orderBy, true, false, true);
        if (!orderBy.equals(q)) {
            sqlQuery.addSelectGroupBy(orderBy);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            if (!levelCollapsed) {
                this.hierarchy.addToFrom(sqlQuery, exp);
            }
            String s = exp.getExpression(sqlQuery);
            String alias = sqlQuery.addSelect(s);
            if (sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue()) continue;
            sqlQuery.addGroupBy(s, alias);
        }
        return sqlQuery.toString();
    }

    private static AggStar chooseAggStar(MemberChildrenConstraint constraint, RolapMember member) {
        RolapStar.Column[] columns;
        if (!MondrianProperties.instance().UseAggregates.get() || !(constraint instanceof SqlContextConstraint)) {
            return null;
        }
        SqlContextConstraint contextConstraint = (SqlContextConstraint)constraint;
        Evaluator evaluator = contextConstraint.getEvaluator();
        RolapCube cube = (RolapCube)evaluator.getCube();
        RolapStar star = cube.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Member[] members = evaluator.getNonAllMembers();
        if (!(members[0] instanceof RolapBaseCubeMeasure)) {
            return null;
        }
        RolapBaseCubeMeasure measure = (RolapBaseCubeMeasure)members[0];
        int bitPosition = ((RolapStar.Measure)measure.getStarMeasure()).getBitPosition();
        int ordinal = measure.getOrdinal();
        RolapCubeLevel childLevel = (RolapCubeLevel)member.getLevel().getChildLevel();
        RolapStar.Column column = childLevel.getStarKeyColumn();
        CellRequest request = RolapAggregationManager.makeRequest(members);
        if (request == null) {
            return null;
        }
        for (RolapStar.Column column1 : columns = request.getConstrainedColumns()) {
            levelBitKey.set(column1.getBitPosition());
        }
        levelBitKey.set(column.getBitPosition());
        measureBitKey.set(bitPosition);
        AggStar aggStar = AggregationManager.instance().findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
        return aggStar;
    }

    public static boolean levelContainsMultipleColumns(RolapLevel level) {
        RolapProperty[] properties;
        if (level.isAll()) {
            return false;
        }
        MondrianDef.Expression keyExp = level.getKeyExp();
        MondrianDef.Expression ordinalExp = level.getOrdinalExp();
        MondrianDef.Expression captionExp = level.getCaptionExp();
        if (!keyExp.equals((Object)ordinalExp)) {
            return true;
        }
        if (captionExp != null && !keyExp.equals((Object)captionExp)) {
            return true;
        }
        for (RolapProperty property : properties = level.getProperties()) {
            if (property.getExp().equals((Object)keyExp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLevelCollapsed(AggStar aggStar, RolapCubeLevel level) {
        boolean levelCollapsed = false;
        if (level.isAll()) {
            return levelCollapsed;
        }
        RolapStar.Column starColumn = level.getStarKeyColumn();
        int bitPos = starColumn.getBitPosition();
        AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
        if (aggColumn.getTable() instanceof AggStar.FactTable) {
            levelCollapsed = true;
        }
        return levelCollapsed;
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint mcc) {
        RolapLevel childLevel = this.getCommonChildLevelForDescendants(parentMembers);
        if (childLevel != null) {
            TupleConstraint lmc = this.sqlConstraintFactory.getDescendantsConstraint(parentMembers, mcc);
            List<RolapMember> list = this.getMembersInLevel(childLevel, 0, Integer.MAX_VALUE, lmc);
            children.addAll(list);
            return;
        }
        for (RolapMember parentMember : parentMembers) {
            this.getMemberChildren(parentMember, children, mcc);
        }
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        if (!parentMember.isAll() && parentMember.isCalculated() && !parentMember.getLevel().isParentChild()) {
            return;
        }
        this.getMemberChildren2(parentMember, children, constraint);
    }

    private RolapLevel getCommonChildLevelForDescendants(List<RolapMember> parents) {
        if (parents.size() < 2) {
            return null;
        }
        RolapLevel parentLevel = null;
        RolapLevel childLevel = null;
        for (RolapMember member : parents) {
            if (member.isCalculated()) {
                return null;
            }
            if (parentLevel == null) {
                parentLevel = member.getLevel();
                if (parentLevel.isParentChild()) {
                    return null;
                }
                childLevel = (RolapLevel)parentLevel.getChildLevel();
                if (childLevel == null) {
                    return null;
                }
                if (!childLevel.isParentChild()) continue;
                return null;
            }
            if (parentLevel == member.getLevel()) continue;
            return null;
        }
        return childLevel;
    }

    private void getMemberChildren2(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        RolapLevel childLevel;
        boolean parentChild;
        String sql;
        RolapLevel parentLevel = parentMember.getLevel();
        if (parentLevel.isParentChild()) {
            sql = this.makeChildMemberSqlPC(parentMember);
            parentChild = true;
            childLevel = parentLevel;
        } else {
            childLevel = (RolapLevel)parentLevel.getChildLevel();
            if (childLevel == null) {
                return;
            }
            if (childLevel.isParentChild()) {
                sql = this.makeChildMemberSql_PCRoot(parentMember);
                parentChild = true;
            } else {
                sql = this.makeChildMemberSql(parentMember, this.dataSource, constraint);
                parentChild = false;
            }
        }
        SqlStatement stmt = RolapUtil.executeQuery(this.dataSource, sql, "SqlMemberSource.getMemberChildren", "while building member cache");
        try {
            RolapMember parentMember2;
            int limit = MondrianProperties.instance().ResultLimit.get();
            boolean checkCacheStatus = true;
            List<SqlStatement.Accessor> accessors = stmt.getAccessors();
            ResultSet resultSet = stmt.getResultSet();
            RolapMember rolapMember = parentMember2 = parentMember instanceof RolapCubeMember ? ((RolapCubeMember)parentMember).getRolapMember() : parentMember;
            while (resultSet.next()) {
                ++stmt.rowCount;
                if (limit > 0 && limit < stmt.rowCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(limit);
                }
                Object value = accessors.get(0).get();
                if (value == null) {
                    value = RolapUtil.sqlNullValue;
                }
                int columnOffset = 1;
                Object captionValue = childLevel.hasCaptionColumn() ? accessors.get(columnOffset++).get() : null;
                Object key = this.cache.makeKey(parentMember2, value);
                RolapMember member = this.cache.getMember(key, checkCacheStatus);
                checkCacheStatus = false;
                if (member == null) {
                    member = this.makeMember(parentMember2, childLevel, value, captionValue, parentChild, stmt, key, columnOffset);
                }
                if (value == RolapUtil.sqlNullValue) {
                    children.toArray();
                    this.addAsOldestSibling(children, member);
                    continue;
                }
                children.add(member);
            }
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public RolapMember makeMember(RolapMember parentMember, RolapLevel childLevel, Object value, Object captionValue, boolean parentChild, SqlStatement stmt, Object key, int columnOffset) throws SQLException {
        RolapMemberBase member = new RolapMemberBase(parentMember, childLevel, value);
        if (!childLevel.getOrdinalExp().equals((Object)childLevel.getKeyExp())) {
            member.setOrdinal(this.lastOrdinal++);
        }
        if (captionValue != null) {
            member.setCaption(captionValue.toString());
        }
        if (parentChild) {
            RolapParentChildMember parentChildMember = childLevel.hasClosedPeer() ? new RolapParentChildMember(parentMember, childLevel, value, member) : new RolapParentChildMemberNoClosure(parentMember, childLevel, value, member);
            member = parentChildMember;
        }
        RolapProperty[] properties = childLevel.getProperties();
        List<SqlStatement.Accessor> accessors = stmt.getAccessors();
        if (!childLevel.getOrdinalExp().equals((Object)childLevel.getKeyExp())) {
            if (this.assignOrderKeys) {
                Object orderKey = accessors.get(columnOffset).get();
                this.setOrderKey(member, orderKey);
            }
            ++columnOffset;
        }
        for (int j = 0; j < properties.length; ++j) {
            RolapProperty property = properties[j];
            member.setProperty(property.getName(), this.getPooledValue(accessors.get(columnOffset + j).get()));
        }
        this.cache.putMember(key, member);
        return member;
    }

    @Override
    public RolapMember allMember() {
        RolapHierarchy rolapHierarchy = this.hierarchy instanceof RolapCubeHierarchy ? ((RolapCubeHierarchy)this.hierarchy).getRolapHierarchy() : this.hierarchy;
        return rolapHierarchy.getAllMember();
    }

    private Object getPooledValue(Object incoming) {
        if (this.valuePool == null) {
            return incoming;
        }
        Object ret = this.valuePool.get(incoming);
        if (ret != null) {
            return ret;
        }
        this.valuePool.put(incoming, incoming);
        return incoming;
    }

    private String makeChildMemberSql_PCRoot(RolapMember member) {
        RolapProperty[] properties;
        SqlQuery sqlQuery = SqlQuery.newQuery(this.dataSource, "while generating query to retrieve children of parent/child hierarchy member " + member);
        Util.assertTrue(member.isAll(), "In the current implementation, parent/child hierarchies must have only one level (plus the 'All' level).");
        RolapLevel level = (RolapLevel)member.getLevel().getChildLevel();
        Util.assertTrue(!level.isAll(), "all level cannot be parent-child");
        Util.assertTrue(level.isUnique(), "parent-child level '" + level + "' must be unique");
        this.hierarchy.addToFrom(sqlQuery, level.getParentExp());
        String parentId = level.getParentExp().getExpression(sqlQuery);
        StringBuilder condition = new StringBuilder(64);
        condition.append(parentId);
        if (level.getNullParentValue() == null || level.getNullParentValue().equalsIgnoreCase("NULL")) {
            condition.append(" IS NULL");
        } else {
            try {
                Util.discard((double)Double.parseDouble(level.getNullParentValue()));
                condition.append(" = ");
                condition.append(level.getNullParentValue());
            }
            catch (NumberFormatException e) {
                condition.append(" = ");
                Util.singleQuoteString(level.getNullParentValue(), condition);
            }
        }
        sqlQuery.addWhere(condition.toString());
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String childId = level.getKeyExp().getExpression(sqlQuery);
        sqlQuery.addSelectGroupBy(childId);
        this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        String orderBy = level.getOrdinalExp().getExpression(sqlQuery);
        sqlQuery.addOrderBy(orderBy, true, false, true);
        if (!orderBy.equals(childId)) {
            sqlQuery.addSelectGroupBy(orderBy);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String s = exp.getExpression(sqlQuery);
            String alias = sqlQuery.addSelect(s);
            if (sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue()) continue;
            sqlQuery.addGroupBy(s, alias);
        }
        return sqlQuery.toString();
    }

    private String makeChildMemberSqlPC(RolapMember member) {
        RolapProperty[] properties;
        SqlQuery sqlQuery = SqlQuery.newQuery(this.dataSource, "while generating query to retrieve children of parent/child hierarchy member " + member);
        RolapLevel level = member.getLevel();
        Util.assertTrue(!level.isAll(), "all level cannot be parent-child");
        Util.assertTrue(level.isUnique(), "parent-child level '" + level + "' must be unique");
        this.hierarchy.addToFrom(sqlQuery, level.getParentExp());
        String parentId = level.getParentExp().getExpression(sqlQuery);
        StringBuilder buf = new StringBuilder();
        sqlQuery.getDialect().quote(buf, member.getKey(), level.getDatatype());
        sqlQuery.addWhere(parentId, " = ", buf.toString());
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String childId = level.getKeyExp().getExpression(sqlQuery);
        sqlQuery.addSelectGroupBy(childId);
        this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        String orderBy = level.getOrdinalExp().getExpression(sqlQuery);
        sqlQuery.addOrderBy(orderBy, true, false, true);
        if (!orderBy.equals(childId)) {
            sqlQuery.addSelectGroupBy(orderBy);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String s = exp.getExpression(sqlQuery);
            String alias = sqlQuery.addSelect(s);
            if (sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue()) continue;
            sqlQuery.addGroupBy(s, alias);
        }
        return sqlQuery.toString();
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List<RolapMember> memberList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleReader.MemberBuilder getMemberBuilder() {
        return this;
    }

    @Override
    public RolapMember getDefaultMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RolapMember getMemberParent(RolapMember member) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ValuePoolFactoryFactory
    extends ObjectFactory.Singleton<ValuePoolFactory> {
        private static final ValuePoolFactoryFactory factory = new ValuePoolFactoryFactory();

        public static ValuePoolFactory getValuePoolFactory() {
            return (ValuePoolFactory)factory.getObject();
        }

        private ValuePoolFactoryFactory() {
            super(ValuePoolFactory.class);
        }

        @Override
        protected StringProperty getStringProperty() {
            return MondrianProperties.instance().SqlMemberSourceValuePoolFactoryClass;
        }

        @Override
        protected ValuePoolFactory getDefault(Class[] parameterTypes, Object[] parameterValues) throws CreationException {
            return new NullValuePoolFactory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NullValuePoolFactory
    implements ValuePoolFactory {
        @Override
        public Map<Object, Object> create(SqlMemberSource source) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValuePoolFactory {
        public Map<Object, Object> create(SqlMemberSource var1);
    }

    private static class RolapParentChildMemberNoClosure
    extends RolapParentChildMember {
        public RolapParentChildMemberNoClosure(RolapMember parentMember, RolapLevel childLevel, Object value, RolapMember dataMember) {
            super(parentMember, childLevel, value, dataMember);
        }

        protected boolean computeCalculated(Member.MemberType memberType) {
            return true;
        }

        public Exp getExpression() {
            return this.getHierarchy().getAggregateChildrenExpression();
        }
    }

    private static class RolapParentChildMember
    extends RolapMemberBase {
        private final RolapMember dataMember;
        private int depth = 0;

        public RolapParentChildMember(RolapMember parentMember, RolapLevel childLevel, Object value, RolapMember dataMember) {
            super(parentMember, childLevel, value);
            this.dataMember = dataMember;
            this.depth = parentMember != null ? parentMember.getDepth() + 1 : 0;
        }

        public Member getDataMember() {
            return this.dataMember;
        }

        public int getDepth() {
            return this.depth;
        }

        public int getOrdinal() {
            return this.dataMember.getOrdinal();
        }
    }
}

