/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import mondrian.olap.MondrianServer;
import mondrian.olap4j.MondrianOlap4jCatalog;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.xmla.XmlaUtil;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MondrianOlap4jDatabaseMetaData
implements OlapDatabaseMetaData {
    final MondrianOlap4jConnection olap4jConnection;
    final MondrianServer mondrianServer;
    private final MondrianOlap4jCatalog olap4jCatalog = new MondrianOlap4jCatalog(this);

    MondrianOlap4jDatabaseMetaData(MondrianOlap4jConnection olap4jConnection) {
        this.olap4jConnection = olap4jConnection;
        this.mondrianServer = MondrianServer.forConnection(olap4jConnection.connection);
    }

    private ResultSet getMetadata(String methodName, Object ... patternValues) {
        HashMap<String, Object> restrictionMap = new HashMap<String, Object>();
        assert (patternValues.length % 2 == 0);
        for (int i = 0; i < patternValues.length / 2; ++i) {
            String key = (String)patternValues[i * 2];
            List<String> value = patternValues[i * 2 + 1];
            if (value == null) continue;
            if (value instanceof String) {
                value = Collections.singletonList((String)((Object)value));
            }
            restrictionMap.put(key, value);
        }
        XmlaUtil.MetadataRowset rowset = XmlaUtil.getMetadataRowset(this.olap4jConnection.connection, "LOCALDB", methodName, restrictionMap);
        return this.olap4jConnection.factory.newFixedResultSet(this.olap4jConnection, rowset.headerList, rowset.rowList);
    }

    private XmlaUtil.Wildcard wildcard(String pattern) {
        return pattern == null ? null : new XmlaUtil.Wildcard(pattern);
    }

    NamedList<Catalog> getCatalogObjects() {
        NamedListImpl list = new NamedListImpl();
        list.add((Object)this.olap4jCatalog);
        return Olap4jUtil.cast((NamedList)list);
    }

    public boolean allProceduresAreCallable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean allTablesAreSelectable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getURL() throws SQLException {
        return this.olap4jConnection.connection.getConnectString();
    }

    public String getUserName() throws SQLException {
        return null;
    }

    public boolean isReadOnly() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean nullsAreSortedLow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getDatabaseProductName() throws SQLException {
        return this.mondrianServer.getVersion().getProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.mondrianServer.getVersion().getVersionString();
    }

    public String getDriverName() throws SQLException {
        return this.olap4jConnection.driver.getName();
    }

    public String getDriverVersion() throws SQLException {
        return this.olap4jConnection.driver.getVersion();
    }

    public int getDriverMajorVersion() {
        return this.olap4jConnection.driver.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.olap4jConnection.driver.getMinorVersion();
    }

    public boolean usesLocalFiles() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getIdentifierQuoteString() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getSQLKeywords() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getNumericFunctions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getStringFunctions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getSystemFunctions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getTimeDateFunctions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getSearchStringEscape() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getExtraNameCharacters() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsColumnAliasing() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsConvert() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsGroupBy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsOuterJoins() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getSchemaTerm() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getProcedureTerm() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getCatalogTerm() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isCatalogAtStart() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getCatalogSeparator() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsPositionedDelete() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsStoredProcedures() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsUnion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsUnionAll() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxCharLiteralLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxColumnNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxColumnsInIndex() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxColumnsInSelect() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxColumnsInTable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxConnections() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxCursorNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxIndexLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxSchemaNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxProcedureNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxCatalogNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxRowSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxStatementLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxStatements() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxTableNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxTablesInSelect() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxUserNameLength() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsTransactions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getSchemas() throws SQLException {
        List<String> headerList = Arrays.asList("TABLE_SCHEM", "TABLE_CAT");
        ArrayList<List<Object>> rowList = new ArrayList<List<Object>>();
        for (Schema schema : this.olap4jCatalog.getSchemas()) {
            rowList.add(Arrays.asList(schema.getName(), schema.getCatalog().getName()));
        }
        return this.olap4jConnection.factory.newFixedResultSet(this.olap4jConnection, headerList, rowList);
    }

    public ResultSet getCatalogs() throws SQLException {
        List<String> headerList = Arrays.asList("TABLE_CAT");
        List<List<Object>> rowList = Collections.singletonList(Arrays.asList(this.olap4jCatalog.getName()));
        return this.olap4jConnection.factory.newFixedResultSet(this.olap4jConnection, headerList, rowList);
    }

    public ResultSet getTableTypes() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getTypeInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsBatchUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public OlapConnection getConnection() {
        return this.olap4jConnection;
    }

    public boolean supportsSavepoints() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsNamedParameters() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.mondrianServer.getVersion().getMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.mondrianServer.getVersion().getMajorVersion();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsStatementPooling() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw this.olap4jConnection.helper.createException("does not implement '" + iface + "'");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public ResultSet getActions(String catalog, String schemaPattern, String cubeNamePattern, String actionNamePattern) throws OlapException {
        return this.getMetadata("MDSCHEMA_ACTIONS", "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "ACTION_NAME", this.wildcard(actionNamePattern));
    }

    public ResultSet getDatasources() throws OlapException {
        return this.getMetadata("DISCOVER_DATASOURCES", new Object[0]);
    }

    public ResultSet getLiterals() throws OlapException {
        return this.getMetadata("DISCOVER_LITERALS", new Object[0]);
    }

    public ResultSet getDatabaseProperties(String dataSourceName, String propertyNamePattern) throws OlapException {
        return this.getMetadata("DISCOVER_PROPERTIES", new Object[0]);
    }

    public ResultSet getProperties(String catalog, String schemaPattern, String cubeNamePattern, String dimensionUniqueName, String hierarchyUniqueName, String levelUniqueName, String memberUniqueName, String propertyNamePattern) throws OlapException {
        return this.getMetadata("MDSCHEMA_PROPERTIES", "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "DIMENSION_UNIQUE_NAME", dimensionUniqueName, "HIERARCHY_UNIQUE_NAME", hierarchyUniqueName, "LEVEL_UNIQUE_NAME", levelUniqueName, "MEMBER_UNIQUE_NAME", memberUniqueName, "PROPERTY_NAME", this.wildcard(propertyNamePattern));
    }

    public String getMdxKeywords() throws OlapException {
        StringBuilder buf = new StringBuilder();
        for (String keyword : this.mondrianServer.getKeywords()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(keyword);
        }
        return buf.toString();
    }

    public ResultSet getCubes(String catalog, String schemaPattern, String cubeNamePattern) throws OlapException {
        return this.getMetadata("MDSCHEMA_CUBES", "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern));
    }

    public ResultSet getDimensions(String catalog, String schemaPattern, String cubeNamePattern, String dimensionNamePattern) throws OlapException {
        return this.getMetadata("MDSCHEMA_DIMENSIONS", "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "DIMSENSION_NAME", this.wildcard(dimensionNamePattern));
    }

    public ResultSet getOlapFunctions(String functionNamePattern) throws OlapException {
        return this.getMetadata("MDSCHEMA_FUNCTIONS", "FUNCTION_NAME", this.wildcard(functionNamePattern));
    }

    public ResultSet getHierarchies(String catalog, String schemaPattern, String cubeNamePattern, String dimensionUniqueName, String hierarchyNamePattern) throws OlapException {
        return this.getMetadata("MDSCHEMA_HIERARCHIES", "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "DIMENSION_UNIQUE_NAME", dimensionUniqueName, "HIERARCHY_NAME", this.wildcard(hierarchyNamePattern));
    }

    public ResultSet getMeasures(String catalog, String schemaPattern, String cubeNamePattern, String measureNamePattern, String measureUniqueName) throws OlapException {
        return this.getMetadata("MDSCHEMA_MEASURES", "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "MEASURE_NAME", this.wildcard(measureNamePattern), "MEASURE_UNIQUE_NAME", measureUniqueName);
    }

    public ResultSet getMembers(String catalog, String schemaPattern, String cubeNamePattern, String dimensionUniqueName, String hierarchyUniqueName, String levelUniqueName, String memberUniqueName, Set<Member.TreeOp> treeOps) throws OlapException {
        String treeOpString;
        if (treeOps != null) {
            int mask = Member.TreeOp.getDictionary().toMask(treeOps);
            treeOpString = String.valueOf(mask);
        } else {
            treeOpString = null;
        }
        return this.getMetadata("MDSCHEMA_MEMBERS", "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "DIMENSION_UNIQUE_NAME", dimensionUniqueName, "HIERARCHY_UNIQUE_NAME", hierarchyUniqueName, "LEVEL_UNIQUE_NAME", levelUniqueName, "MEMBER_UNIQUE_NAME", memberUniqueName, "TREE_OP", treeOpString);
    }

    public ResultSet getLevels(String catalog, String schemaPattern, String cubeNamePattern, String dimensionUniqueName, String hierarchyUniqueName, String levelNamePattern) throws OlapException {
        return this.getMetadata("MDSCHEMA_LEVELS", "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "DIMENSION_UNIQUE_NAME", dimensionUniqueName, "HIERARCHY_UNIQUE_NAME", hierarchyUniqueName, "LEVEL_NAME", this.wildcard(levelNamePattern));
    }

    public ResultSet getSets(String catalog, String schemaPattern, String cubeNamePattern, String setNamePattern) throws OlapException {
        return this.getMetadata("MDSCHEMA_SETS", "CATALOG_NAME", catalog, "SCHEMA_NAME", this.wildcard(schemaPattern), "CUBE_NAME", this.wildcard(cubeNamePattern), "SET_NAME", this.wildcard(setNamePattern));
    }
}

