/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

public interface AxisOrdinal {
    public String name();

    public int logicalOrdinal();

    public boolean isFilter();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StandardAxisOrdinal implements AxisOrdinal
    {
        NONE,
        SLICER,
        COLUMNS,
        ROWS,
        PAGES,
        CHAPTERS,
        SECTIONS;


        public static AxisOrdinal forLogicalOrdinal(final int ordinal) {
            if (ordinal + 2 > SECTIONS.ordinal()) {
                return new AxisOrdinal(){

                    public String name() {
                        return "AXIS(" + ordinal + ")";
                    }

                    public int logicalOrdinal() {
                        return ordinal;
                    }

                    public boolean isFilter() {
                        return false;
                    }
                };
            }
            return StandardAxisOrdinal.values()[ordinal + 2];
        }

        @Override
        public int logicalOrdinal() {
            return this.ordinal() - 2;
        }

        @Override
        public boolean isFilter() {
            return this == SLICER;
        }
    }
}

