/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.CsrfGuardException;
import org.owasp.csrfguard.action.AbstractAction;
import org.owasp.csrfguard.log.LogLevel;

public final class Log
extends AbstractAction {
    private static final long serialVersionUID = 8238761463376338707L;

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, CsrfGuardException csrfe, CsrfGuard csrfGuard) throws CsrfGuardException {
        String logMessage = this.getParameter("Message");
        logMessage = logMessage.replaceAll("%exception%", String.valueOf(csrfe));
        logMessage = logMessage.replaceAll("%exception_message%", csrfe.getLocalizedMessage());
        logMessage = logMessage.replaceAll("%remote_ip%", request.getRemoteAddr());
        logMessage = logMessage.replaceAll("%remote_host%", request.getRemoteHost());
        logMessage = logMessage.replaceAll("%remote_port%", String.valueOf(request.getRemotePort()));
        logMessage = logMessage.replaceAll("%local_ip%", request.getLocalAddr());
        logMessage = logMessage.replaceAll("%local_host%", request.getLocalName());
        logMessage = logMessage.replaceAll("%local_port%", String.valueOf(request.getLocalPort()));
        logMessage = logMessage.replaceAll("%request_uri%", request.getRequestURI());
        logMessage = logMessage.replaceAll("%request_url%", request.getRequestURL().toString());
        logMessage = request.getRemoteUser() != null ? logMessage.replaceAll("%user%", request.getRemoteUser()) : logMessage.replaceAll("%user%", "<anonymous>");
        csrfGuard.getLogger().log(LogLevel.Error, logMessage);
    }
}

