/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class NumberToShortTransform
extends Transform {
    private Class<?> sourceType;
    private boolean isNarrowing;

    public NumberToShortTransform(Class<?> sourceType, boolean isNarrowing) {
        this.sourceType = sourceType;
        this.isNarrowing = isNarrowing;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
        }
        return ((Number)value).shortValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.SHORT;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing;
    }
}

