/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.PdfExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.AbstractReportOutput;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportOutput;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public class PdfReportOutput
extends AbstractReportOutput {
    private static final Log log = LogFactory.getLog(PdfReportOutput.class);
    private PdfExportParametersBean exportParams;

    @Override
    public ReportOutput getOutput(EngineService engineService, ExecutionContext executionContext, String reportUnitURI, DataContainer pdfData, JRHyperlinkProducerFactory hyperlinkProducerFactory, RepositoryService repositoryService, JasperPrint jasperPrint, String baseFilename, Locale locale, String characterEncoding) throws JobExecutionException {
        HashMap<JRExporterParameter, Object> params = new HashMap<JRExporterParameter, Object>();
        params.put(JRExporterParameter.JASPER_PRINT, jasperPrint);
        boolean close = true;
        OutputStream pdfDataOut = pdfData.getOutputStream();
        try {
            params.put(JRExporterParameter.OUTPUT_STREAM, pdfDataOut);
            Map localizedFontMap = this.exportParams.getFontMap(locale);
            if (localizedFontMap != null) {
                params.put(JRExporterParameter.FONT_MAP, localizedFontMap);
            }
            engineService.exportToPdf(executionContext, reportUnitURI, params);
            close = false;
            pdfDataOut.close();
        }
        catch (IOException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (close) {
                try {
                    pdfDataOut.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing stream", (Throwable)e);
                }
            }
        }
        String filename = baseFilename + ".pdf";
        return new ReportOutput(pdfData, "pdf", filename);
    }

    public PdfExportParametersBean getExportParams() {
        return this.exportParams;
    }

    public void setExportParams(PdfExportParametersBean exportParams) {
        this.exportParams = exportParams;
    }
}

