/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobMailNotificationModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobMailRecipient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PersistentReportJobMailNotification {
    private long id;
    private int version = -1;
    private List recipients;
    private String subject;
    private String messageText;
    private byte resultSendType;
    private boolean skipEmptyReports;
    private String messageTextWhenJobFails = null;
    private boolean includingStackTraceWhenJobFails = false;
    private boolean SkipNotificationWhenJobFails = false;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public byte getResultSendType() {
        return this.resultSendType;
    }

    public void setResultSendType(byte resultSendType) {
        this.resultSendType = resultSendType;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public List getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List toAddresses) {
        this.recipients = toAddresses;
    }

    public String getMessageTextWhenJobFails() {
        return this.messageTextWhenJobFails;
    }

    public void setMessageTextWhenJobFails(String messageTextWhenJobFails) {
        this.messageTextWhenJobFails = messageTextWhenJobFails;
    }

    public boolean isIncludingStackTraceWhenJobFails() {
        return this.includingStackTraceWhenJobFails;
    }

    public void setIncludingStackTraceWhenJobFails(boolean includingStackTraceWhenJobFails) {
        this.includingStackTraceWhenJobFails = includingStackTraceWhenJobFails;
    }

    public boolean isSkipNotificationWhenJobFails() {
        return this.SkipNotificationWhenJobFails;
    }

    public void setSkipNotificationWhenJobFails(boolean skipNotificationWhenJobFails) {
        this.SkipNotificationWhenJobFails = skipNotificationWhenJobFails;
    }

    public void copyFrom(ReportJobMailNotification mailNotification) {
        this.copyRecipientsFrom(mailNotification);
        this.setSubject(mailNotification.getSubject());
        this.setMessageText(mailNotification.getMessageText());
        this.setResultSendType(mailNotification.getResultSendType());
        this.setSkipEmptyReports(mailNotification.isSkipEmptyReports());
        this.setMessageTextWhenJobFails(mailNotification.getMessageTextWhenJobFails());
        this.setIncludingStackTraceWhenJobFails(mailNotification.isIncludingStackTraceWhenJobFails());
        this.setSkipNotificationWhenJobFails(mailNotification.isSkipNotificationWhenJobFails());
    }

    public void copyFrom(ReportJobMailNotificationModel mailNotification) {
        ReportJobMailNotification originalCopy = this.toClient();
        ArrayList newRecipients = new ArrayList();
        if (mailNotification.isToAddressesModified()) {
            this.collectRecipients(newRecipients, mailNotification.getToAddresses(), (byte)1);
        } else {
            this.collectRecipients(newRecipients, originalCopy.getToAddresses(), (byte)1);
        }
        if (mailNotification.isCcAddressesModified()) {
            this.collectRecipients(newRecipients, mailNotification.getCcAddresses(), (byte)2);
        } else {
            this.collectRecipients(newRecipients, originalCopy.getCcAddresses(), (byte)2);
        }
        if (mailNotification.isBccAddressesModified()) {
            this.collectRecipients(newRecipients, mailNotification.getBccAddresses(), (byte)3);
        } else {
            this.collectRecipients(newRecipients, originalCopy.getBccAddresses(), (byte)3);
        }
        this.setRecipients(newRecipients);
        if (mailNotification.isSubjectModified()) {
            this.setSubject(mailNotification.getSubject());
        }
        if (mailNotification.isMessageTextModified()) {
            this.setMessageText(mailNotification.getMessageText());
        }
        if (mailNotification.isResultSendTypeModified()) {
            this.setResultSendType(mailNotification.getResultSendTypeCode());
        }
        if (mailNotification.isSkipEmptyReportsModified()) {
            this.setSkipEmptyReports(mailNotification.isSkipEmptyReports());
        }
        if (mailNotification.isMessageTextWhenJobFailsModified()) {
            this.setMessageTextWhenJobFails(mailNotification.getMessageTextWhenJobFails());
        }
        if (mailNotification.isIncludingStackTraceWhenJobFailsModified()) {
            this.setIncludingStackTraceWhenJobFails(mailNotification.isIncludingStackTraceWhenJobFails());
        }
        if (mailNotification.isSkipNotificationWhenJobFailsModified()) {
            this.setSkipNotificationWhenJobFails(mailNotification.isSkipNotificationWhenJobFails());
        }
    }

    protected void copyRecipientsFrom(ReportJobMailNotification mailNotification) {
        ArrayList newRecipients = new ArrayList();
        this.collectRecipients(newRecipients, mailNotification.getToAddresses(), (byte)1);
        this.collectRecipients(newRecipients, mailNotification.getCcAddresses(), (byte)2);
        this.collectRecipients(newRecipients, mailNotification.getBccAddresses(), (byte)3);
        this.setRecipients(newRecipients);
    }

    protected void collectRecipients(List recipientsList, List addresses, byte type) {
        if (addresses != null && !addresses.isEmpty()) {
            for (String address : addresses) {
                PersistentReportJobMailRecipient recipient = new PersistentReportJobMailRecipient();
                recipient.setType(type);
                recipient.setAddress(address);
                recipientsList.add(recipient);
            }
        }
    }

    public ReportJobMailNotification toClient() {
        ReportJobMailNotification mail = new ReportJobMailNotification();
        mail.setId(this.getId());
        mail.setVersion(this.getVersion());
        this.copyAddressesTo(mail);
        mail.setSubject(this.getSubject());
        mail.setMessageText(this.getMessageText());
        mail.setResultSendType(this.getResultSendType());
        mail.setSkipEmptyReports(this.isSkipEmptyReports());
        mail.setMessageTextWhenJobFails(this.getMessageTextWhenJobFails());
        mail.setIncludingStackTraceWhenJobFails(this.isIncludingStackTraceWhenJobFails());
        mail.setSkipNotificationWhenJobFails(this.isSkipNotificationWhenJobFails());
        return mail;
    }

    protected void copyAddressesTo(ReportJobMailNotification mail) {
        HashMap collectedAddresses = new HashMap();
        collectedAddresses.put(new Byte(1), new ArrayList());
        collectedAddresses.put(new Byte(3), new ArrayList());
        collectedAddresses.put(new Byte(2), new ArrayList());
        if (this.getRecipients() != null) {
            for (PersistentReportJobMailRecipient recipient : this.getRecipients()) {
                ((List)collectedAddresses.get(new Byte(recipient.getType()))).add(recipient.getAddress());
            }
        }
        mail.setToAddresses((List)collectedAddresses.get(new Byte(1)));
        mail.setCcAddresses((List)collectedAddresses.get(new Byte(2)));
        mail.setBccAddresses((List)collectedAddresses.get(new Byte(3)));
    }

    public boolean isNew() {
        return this.getVersion() == -1;
    }

    public boolean isSkipEmptyReports() {
        return this.skipEmptyReports;
    }

    public void setSkipEmptyReports(boolean skipEmptyReports) {
        this.skipEmptyReports = skipEmptyReports;
    }
}

