/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobCalendarTriggerModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentReportJobTrigger;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class PersistentReportJobCalendarTrigger
extends PersistentReportJobTrigger {
    private static final String ENUM_SEPARATOR = ",";
    private static final String ENUM_SEPARATOR_REGEX = ",";
    private String minutes;
    private String hours;
    private byte daysType;
    private String weekDays;
    private String monthDays;
    private String months;

    public String getHours() {
        return this.hours;
    }

    public void setHours(String hours) {
        this.hours = hours;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    @Override
    public void copyFrom(ReportJobTrigger trigger) {
        super.copyFrom(trigger);
        ReportJobCalendarTrigger calendarTrigger = (ReportJobCalendarTrigger)trigger;
        this.setMinutes(calendarTrigger.getMinutes());
        this.setHours(calendarTrigger.getHours());
        this.setDaysType(calendarTrigger.getDaysType());
        this.setWeekDays(PersistentReportJobCalendarTrigger.toEnumerationString(calendarTrigger.getWeekDays()));
        this.setMonthDays(calendarTrigger.getMonthDays());
        this.setMonths(PersistentReportJobCalendarTrigger.toEnumerationString(calendarTrigger.getMonths()));
    }

    @Override
    public void copyFromModel(ReportJobTrigger trigger) {
        super.copyFrom(trigger);
        ReportJobCalendarTriggerModel calendarTrigger = (ReportJobCalendarTriggerModel)trigger;
        if (calendarTrigger.isCalendarNameModified()) {
            this.setCalendarName(trigger.getCalendarName());
        }
        if (calendarTrigger.isTimezoneModified()) {
            this.setTimezone(trigger.getTimezone());
        }
        if (calendarTrigger.isStartTypeModified()) {
            this.setStartType(trigger.getStartType());
        }
        if (calendarTrigger.isStartDateModified()) {
            this.setStartDate(this.toTimestamp(trigger.getStartDate()));
        }
        if (calendarTrigger.isEndDateModified()) {
            this.setEndDate(this.toTimestamp(trigger.getEndDate()));
        }
        if (calendarTrigger.isMinutesModified()) {
            this.setMinutes(calendarTrigger.getMinutes());
        }
        if (calendarTrigger.isHoursModified()) {
            this.setHours(calendarTrigger.getHours());
        }
        if (calendarTrigger.isDaysTypeModified()) {
            this.setDaysType(calendarTrigger.getDaysType());
        }
        if (calendarTrigger.isWeekDaysModified()) {
            this.setWeekDays(PersistentReportJobCalendarTrigger.toEnumerationString(calendarTrigger.getWeekDays()));
        }
        if (calendarTrigger.isMonthDaysModified()) {
            this.setMonthDays(calendarTrigger.getMonthDays());
        }
        if (calendarTrigger.isMonthsModified()) {
            this.setMonths(PersistentReportJobCalendarTrigger.toEnumerationString(calendarTrigger.getMonths()));
        }
        if (calendarTrigger.isMisfireInstructionModified()) {
            this.setMisfireInstruction(calendarTrigger.getMisfireInstruction());
        }
    }

    @Override
    public ReportJobTrigger toClient() {
        ReportJobCalendarTrigger trigger = new ReportJobCalendarTrigger();
        super.copyTo((ReportJobTrigger)trigger);
        trigger.setMinutes(this.getMinutes());
        trigger.setHours(this.getHours());
        trigger.setDaysType(this.getDaysType());
        trigger.setWeekDays(this.parseEnumerationString(this.getWeekDays()));
        trigger.setMonthDays(this.getMonthDays());
        trigger.setMonths(this.parseEnumerationString(this.getMonths()));
        return trigger;
    }

    @Override
    public boolean supports(Class triggerClass) {
        return ReportJobCalendarTrigger.class.isAssignableFrom(triggerClass) || ReportJobCalendarTriggerModel.class.isAssignableFrom(triggerClass);
    }

    public byte getDaysType() {
        return this.daysType;
    }

    public void setDaysType(byte daysType) {
        this.daysType = daysType;
    }

    public String getMonthDays() {
        return this.monthDays;
    }

    public void setMonthDays(String monthDays) {
        this.monthDays = monthDays;
    }

    public String getMonths() {
        return this.months;
    }

    public void setMonths(String months) {
        this.months = months;
    }

    public String getWeekDays() {
        return this.weekDays;
    }

    public void setWeekDays(String weekDays) {
        this.weekDays = weekDays;
    }

    protected static String toEnumerationString(Set vals) {
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        TreeSet sorted = new TreeSet(vals);
        for (Byte val : sorted) {
            str.append(val.byteValue());
            str.append(",");
        }
        return str.substring(0, str.length() - 1);
    }

    protected SortedSet parseEnumerationString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        TreeSet<Byte> valsSet = new TreeSet<Byte>();
        String[] vals = str.split(",");
        for (int i = 0; i < vals.length; ++i) {
            String strVal = vals[i];
            try {
                Byte val = Byte.valueOf(strVal);
                valsSet.add(val);
                continue;
            }
            catch (NumberFormatException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
        }
        return valsSet;
    }
}

