/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.ProtectionDomainProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class PermissionsListProtectionDomainProvider
implements ProtectionDomainProvider,
InitializingBean {
    private static final Log log = LogFactory.getLog(PermissionsListProtectionDomainProvider.class);
    private List<Permission> permissions;
    private ProtectionDomain protectionDomain;

    public void afterPropertiesSet() throws Exception {
        if (System.getSecurityManager() == null) {
            log.warn((Object)"A security manager has not been configured for the JVM. The protection domain set for the reports will NOT be effective.");
        }
        this.protectionDomain = this.createProtectionDomain();
    }

    protected ProtectionDomain createProtectionDomain() {
        CodeSource codeSource = this.getCodeSource();
        PermissionCollection permissionCollection = this.getPermissionCollection();
        return new ProtectionDomain(codeSource, permissionCollection);
    }

    protected CodeSource getCodeSource() {
        try {
            URL location = new URL(null, "repo:/", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    throw new IOException("Cannot read from repo:/ location");
                }
            });
            return new CodeSource(location, (Certificate[])null);
        }
        catch (MalformedURLException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected PermissionCollection getPermissionCollection() {
        Permissions permissionCollection = new Permissions();
        if (this.permissions != null) {
            for (Permission permission : this.permissions) {
                permissionCollection.add(permission);
            }
        }
        return permissionCollection;
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }
}

