/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataConverterFactory {
    private static Map converterMap = new HashMap();
    private static Map pumpUpDataTypeMap;

    public static String getPumpUpType(String originalType) {
        return (String)pumpUpDataTypeMap.get(originalType);
    }

    public static DataConverter createConverter(String type) {
        String converterClass = (String)converterMap.get(type);
        if (converterClass == null) {
            return null;
        }
        converterClass = "com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataConverterFactory$" + converterClass;
        try {
            return (DataConverter)Class.forName(converterClass).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        converterMap.put("java.lang.String", "StringConverter");
        converterMap.put("java.lang.Byte", "ByteConverter");
        converterMap.put("java.lang.Short", "ShortConverter");
        converterMap.put("java.lang.Integer", "IntegerConverter");
        converterMap.put("java.lang.Float", "FloatConverter");
        converterMap.put("java.lang.Double", "DoubleConverter");
        converterMap.put("java.lang.Number", "DoubleConverter");
        converterMap.put("java.util.Date", "DateConverter");
        pumpUpDataTypeMap = new HashMap();
        pumpUpDataTypeMap.put("java.lang.Byte", "java.lang.Long");
        pumpUpDataTypeMap.put("java.lang.Short", "java.lang.Long");
        pumpUpDataTypeMap.put("java.lang.Integer", "java.lang.Long");
        pumpUpDataTypeMap.put("java.lang.Float", "java.lang.Double");
        pumpUpDataTypeMap.put("java.lang.Number", "java.lang.Double");
    }

    public static class LongAdapter
    implements DataConverter {
        @Override
        public Object convert(Object value) {
            if (value == null || value.getClass().equals(this.getType())) {
                return (Long)value;
            }
            if (value instanceof Number) {
                long l = ((Number)value).longValue();
                return new Long(l);
            }
            throw new IllegalArgumentException("passed value of class " + value.getClass().getName() + " to LongColumn.set(), expecting subclass of Number");
        }

        public Class getType() {
            return Long.class;
        }
    }

    public static class ByteConverter
    implements DataConverter {
        @Override
        public Object convert(Object value) {
            if (value == null || value.getClass().equals(this.getType())) {
                return (Byte)value;
            }
            if (value instanceof Number) {
                byte b = ((Number)value).byteValue();
                return b;
            }
            throw new IllegalArgumentException("passed value of class " + value.getClass().getName() + " to ShortColumn.set(), expecting subclass of Number");
        }

        public Class getType() {
            return Byte.class;
        }
    }

    public static class ShortConverter
    implements DataConverter {
        @Override
        public Object convert(Object value) {
            if (value == null || value.getClass().equals(this.getType())) {
                return (Short)value;
            }
            if (value instanceof Number) {
                short s = ((Number)value).shortValue();
                return new Short(s);
            }
            throw new IllegalArgumentException("passed value of class " + value.getClass().getName() + " to ShortColumn.set(), expecting subclass of Number");
        }

        public Class getType() {
            return Short.class;
        }
    }

    public static class IntegerConverter
    implements DataConverter {
        @Override
        public Object convert(Object value) {
            if (value == null || value.getClass().equals(this.getType())) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                int i = ((Number)value).intValue();
                return new Integer(i);
            }
            throw new IllegalArgumentException("passed value of class " + value.getClass().getName() + " to IntegerColumn.set(), expecting subclass of Number");
        }

        public Class getType() {
            return Integer.class;
        }
    }

    public static class DoubleConverter
    implements DataConverter {
        @Override
        public Object convert(Object value) {
            if (value == null || value.getClass().equals(this.getType())) {
                return (Double)value;
            }
            if (value instanceof Number) {
                double d = ((Number)value).doubleValue();
                return new Double(d);
            }
            throw new IllegalArgumentException("passed value of class " + value.getClass().getName() + " to DoubleColumn.set(), expecting subclass of Number");
        }

        public Class getType() {
            return Double.class;
        }
    }

    public static class FloatConverter
    implements DataConverter {
        @Override
        public Object convert(Object value) {
            if (value == null || value.getClass().equals(this.getType())) {
                return (Float)value;
            }
            if (value instanceof Number) {
                float f = ((Number)value).floatValue();
                return new Float(f);
            }
            throw new IllegalArgumentException("passed value of class " + value.getClass().getName() + " to FloatColumn.set(), expecting subclass of Number");
        }

        public Class getType() {
            return Float.class;
        }
    }

    public static class DateConverter
    implements DataConverter {
        @Override
        public Object convert(Object value) {
            if (value == null || value.getClass().equals(this.getType())) {
                return (Date)value;
            }
            if (value instanceof Date) {
                long time = ((Date)value).getTime();
                return new Date(time);
            }
            throw new IllegalArgumentException("passed value of class " + value.getClass().getName() + " to DateColumn.set(), expecting subclass of java.util.Date");
        }

        public Class getType() {
            return Date.class;
        }
    }

    public static class StringConverter
    implements DataConverter {
        @Override
        public Object convert(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }

    public static interface DataConverter {
        public Object convert(Object var1);
    }
}

