/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsEc2MetadataClient;
import com.jaspersoft.jasperserver.api.logging.diagnostic.domain.DiagnosticAttribute;
import com.jaspersoft.jasperserver.api.logging.diagnostic.helper.DiagnosticAttributeBuilder;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.Diagnostic;
import com.jaspersoft.jasperserver.api.logging.diagnostic.service.DiagnosticCallback;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class AwsProperties
implements Diagnostic,
InitializingBean {
    private Boolean securityGroupChangesEnabled;
    private String securityGroupName;
    private String securityGroupDescription;
    private String securityGroupIngressPublicIp;
    private Boolean suppressEc2CredentialsWarnings;
    public static final String DB_SECURITY_GROUP_CHANGES_ENABLED = "aws.db.security.group.changes.enabled";
    public static final String DB_SECURITY_GROUP_NAME = "aws.db.security.group.name";
    public static final String DB_SECURITY_GROUP_DESCRIPTION = "aws.db.security.group.description";
    public static final String DB_SECURITY_GROUP_INGRESS_PUBLIC_IP = "aws.db.security.group.ingressPublicIp";
    public static final String DB_SECURITY_GROUP_CHANGES_SUPPRESS_EC2_CREDENTIALS_WARNINGS = "aws.db.security.group.suppressEc2CredentialsWarnings";
    private MessageSource messageSource;
    private AwsEc2MetadataClient awsEc2MetadataClient;

    public Boolean isSecurityGroupChangesEnabled() {
        return this.securityGroupChangesEnabled;
    }

    public void setSecurityGroupChangesEnabled(Boolean securityGroupChangesEnabled) {
        this.securityGroupChangesEnabled = securityGroupChangesEnabled;
    }

    public String getSecurityGroupName() {
        return this.securityGroupName;
    }

    public void setSecurityGroupName(String securityGroupName) {
        this.securityGroupName = securityGroupName;
    }

    public String getSecurityGroupDescription() {
        return this.securityGroupDescription;
    }

    public void setSecurityGroupDescription(String securityGroupDescription) {
        this.securityGroupDescription = securityGroupDescription;
    }

    public String getSecurityGroupIngressPublicIp() {
        return this.securityGroupIngressPublicIp;
    }

    public void setSecurityGroupIngressPublicIp(String securityGroupIngressPublicIp) {
        this.securityGroupIngressPublicIp = securityGroupIngressPublicIp;
    }

    public Boolean isSuppressEc2CredentialsWarnings() {
        return this.suppressEc2CredentialsWarnings;
    }

    public void setSuppressEc2CredentialsWarnings(Boolean suppressEc2CredentialsWarnings) {
        this.suppressEc2CredentialsWarnings = suppressEc2CredentialsWarnings;
    }

    public void setAwsEc2MetadataClient(AwsEc2MetadataClient awsEc2MetadataClient) {
        this.awsEc2MetadataClient = awsEc2MetadataClient;
    }

    public Map<DiagnosticAttribute, DiagnosticCallback> getDiagnosticData() {
        return new DiagnosticAttributeBuilder().addDiagnosticAttribute("AwsSettings", (DiagnosticCallback)new DiagnosticCallback<Map<String, Object>>(){

            public Map<String, Object> getDiagnosticAttributeValue() {
                HashMap<String, Object> awsSettings = new HashMap<String, Object>();
                awsSettings.put(AwsProperties.DB_SECURITY_GROUP_CHANGES_ENABLED, AwsProperties.this.generateValueWithDescription(AwsProperties.this.securityGroupChangesEnabled, AwsProperties.DB_SECURITY_GROUP_CHANGES_ENABLED));
                awsSettings.put(AwsProperties.DB_SECURITY_GROUP_NAME, AwsProperties.this.generateValueWithDescription(AwsProperties.this.securityGroupName, AwsProperties.DB_SECURITY_GROUP_NAME));
                awsSettings.put(AwsProperties.DB_SECURITY_GROUP_DESCRIPTION, AwsProperties.this.generateValueWithDescription(AwsProperties.this.securityGroupDescription, AwsProperties.DB_SECURITY_GROUP_DESCRIPTION));
                awsSettings.put(AwsProperties.DB_SECURITY_GROUP_INGRESS_PUBLIC_IP, AwsProperties.this.generateValueWithDescription(AwsProperties.this.securityGroupIngressPublicIp, AwsProperties.DB_SECURITY_GROUP_INGRESS_PUBLIC_IP));
                awsSettings.put(AwsProperties.DB_SECURITY_GROUP_CHANGES_SUPPRESS_EC2_CREDENTIALS_WARNINGS, AwsProperties.this.generateValueWithDescription(AwsProperties.this.suppressEc2CredentialsWarnings, AwsProperties.DB_SECURITY_GROUP_CHANGES_SUPPRESS_EC2_CREDENTIALS_WARNINGS));
                return awsSettings;
            }
        }).build();
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    private String generateValueWithDescription(Object awsValue, String messagePath) {
        Locale locale = LocaleContextHolder.getLocale();
        String description = this.messageSource.getMessage(messagePath, null, "", locale);
        description = description == null || description.isEmpty() ? "" : " (" + description + ")";
        return awsValue + description;
    }

    public void afterPropertiesSet() throws Exception {
        String instanceId = this.awsEc2MetadataClient.getEc2InstanceMetadataItem("/latest/meta-data/instance-id/");
        this.securityGroupName = StringUtils.isNotEmpty((String)instanceId) ? this.getSecurityGroupName() + "_" + instanceId : this.getSecurityGroupName();
    }
}

