/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.jaspersoft.jasperserver.api.JSShowOnlyErrorMessage;
import com.jaspersoft.jasperserver.api.common.util.spring.StaticApplicationContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class AwsCredentialUtil {
    private static final Log logger = LogFactory.getLog(AwsCredentialUtil.class);

    public static AWSCredentials getAWSCredentials(String awsAccessKey, String awsSecretKey, String roleARN) {
        AWSCredentials awsCredentials;
        if (StringUtils.isNotEmpty((String)awsAccessKey) && StringUtils.isNotEmpty((String)awsSecretKey)) {
            awsCredentials = new BasicAWSCredentials(awsAccessKey.trim(), awsSecretKey.trim());
            if (StringUtils.isNotEmpty((String)roleARN)) {
                AWSSecurityTokenServiceClient stsClient = new AWSSecurityTokenServiceClient(awsCredentials);
                AssumeRoleRequest assumeRequest = new AssumeRoleRequest().withRoleArn(roleARN.trim()).withRoleSessionName("JRSRequest");
                AssumeRoleResult assumeResult = null;
                try {
                    assumeResult = stsClient.assumeRole(assumeRequest);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    throw new JSShowOnlyErrorMessage(ex.getMessage());
                }
                awsCredentials = new BasicSessionCredentials(assumeResult.getCredentials().getAccessKeyId(), assumeResult.getCredentials().getSecretAccessKey(), assumeResult.getCredentials().getSessionToken());
            }
        } else {
            DefaultAWSCredentialsProviderChain instanceCredentialsProvider = new DefaultAWSCredentialsProviderChain();
            try {
                awsCredentials = instanceCredentialsProvider.getCredentials();
            }
            catch (Exception ex) {
                ApplicationContext ctx = StaticApplicationContext.getApplicationContext();
                MessageSource message = (MessageSource)ctx.getBean("messageSource", MessageSource.class);
                logger.error((Object)"Exception loading default JRS instance credentials", (Throwable)ex);
                throw new JSShowOnlyErrorMessage(message.getMessage("aws.exception.datasource.load.default.credentials", null, LocaleContextHolder.getLocale()));
            }
        }
        return awsCredentials;
    }
}

