/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.service.JdbcDriverService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.DbcpDataSource;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.PooledDataSource;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.PooledJdbcDataSourceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPoolFactory;

public class DbcpDataSourceFactory
implements PooledJdbcDataSourceFactory {
    private static final Log log = LogFactory.getLog(DbcpDataSourceFactory.class);
    private ObjectPoolFactory objectPoolFactory;
    private JdbcDriverService jdbcDriverService;

    @Override
    public PooledDataSource createPooledDataSource(String driverClass, String url, String username, String password) {
        this.registerDriver(driverClass);
        return new DbcpDataSource(this.objectPoolFactory, url, username, password);
    }

    @Override
    public PooledDataSource createPooledDataSource(String driverClass, String url, String username, String password, boolean defaultReadOnly, boolean defaultAutoCommit) {
        this.registerDriver(driverClass);
        return new DbcpDataSource(this.objectPoolFactory, url, username, password, defaultReadOnly, defaultAutoCommit);
    }

    protected void registerDriver(String driverClass) {
        try {
            this.jdbcDriverService.register(driverClass);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper(e);
        }
    }

    public ObjectPoolFactory getObjectPoolFactory() {
        return this.objectPoolFactory;
    }

    public void setObjectPoolFactory(ObjectPoolFactory genericObjectPoolFactory) {
        this.objectPoolFactory = genericObjectPoolFactory;
    }

    public void setJdbcDriverService(JdbcDriverService jdbcDriverService) {
        this.jdbcDriverService = jdbcDriverService;
    }
}

