/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceDefinition;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CustomReportDataSourceServiceFactory
implements ReportDataSourceServiceFactory,
ApplicationContextAware {
    private ApplicationContext ctx;
    private List<CustomDataSourceDefinition> customDataSourceDefs = new ArrayList<CustomDataSourceDefinition>();
    private ResourceFactory mappingResourceFactory;

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.ctx = arg0;
    }

    protected ApplicationContext getApplicationContext() {
        return this.ctx;
    }

    public CustomReportDataSource createDataSource(String dsTypeName) {
        CustomDataSourceDefinition cdsd = this.getDefinitionByName(dsTypeName);
        if (cdsd == null) {
            throw new IllegalArgumentException("unknown custom data source type name '" + dsTypeName + "'");
        }
        CustomReportDataSource cds = (CustomReportDataSource)this.mappingResourceFactory.newResource(null, CustomReportDataSource.class);
        cds.setServiceClass(cdsd.getServiceClassName());
        cds.setDataSourceName(dsTypeName);
        cdsd.setDefaultValues(cds);
        return cds;
    }

    public ReportDataSourceService createService(ReportDataSource reportDataSource) {
        ReportDataSourceService service;
        if (!(reportDataSource instanceof CustomReportDataSource)) {
            throw new JSException("jsexception.invalid.custom.datasource", new Object[]{reportDataSource.getClass()});
        }
        CustomReportDataSource customDataSource = (CustomReportDataSource)reportDataSource;
        CustomDataSourceDefinition dsDef = this.getDefinition(customDataSource);
        if (dsDef.getCustomFactory() != null) {
            return dsDef.getCustomFactory().createService((ReportDataSource)customDataSource);
        }
        String serviceClassName = customDataSource.getServiceClass();
        try {
            Class<?> serviceClass = Class.forName(serviceClassName);
            service = (ReportDataSourceService)serviceClass.newInstance();
        }
        catch (Exception e) {
            JSException ex = new JSException("jsexception.creating.custom.datasource", (Throwable)e);
            ex.setArgs(new Object[]{serviceClassName});
            throw ex;
        }
        try {
            dsDef.setDataSourceServiceProperties(customDataSource, service);
        }
        catch (Exception e) {
            JSException ex = new JSException("jsexception.setting.custom.datasource.props", (Throwable)e);
            ex.setArgs(new Object[]{serviceClassName});
            throw ex;
        }
        return service;
    }

    public void addDefinition(CustomDataSourceDefinition def) {
        this.customDataSourceDefs.add(def);
    }

    public List<CustomDataSourceDefinition> getDefinitions() {
        return this.customDataSourceDefs;
    }

    public CustomDataSourceDefinition getDefinitionByServiceClass(String serviceClass) {
        for (CustomDataSourceDefinition cds : this.getDefinitions()) {
            if (!cds.getServiceClassName().equals(serviceClass)) continue;
            return cds;
        }
        return null;
    }

    public CustomDataSourceDefinition getDefinitionByName(String name) {
        for (CustomDataSourceDefinition cds : this.getDefinitions()) {
            if (!cds.getName().equals(name)) continue;
            return cds;
        }
        return null;
    }

    public CustomDataSourceDefinition getDefinition(CustomReportDataSource cds) {
        if (cds.getDataSourceName() != null) {
            return this.getDefinitionByName(cds.getDataSourceName());
        }
        return this.getDefinitionByServiceClass(cds.getServiceClass());
    }

    public ResourceFactory getMappingResourceFactory() {
        return this.mappingResourceFactory;
    }

    public void setMappingResourceFactory(ResourceFactory mappingResourceFactory) {
        this.mappingResourceFactory = mappingResourceFactory;
    }
}

