/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl;

import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.ConnectionFactory;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.DataSource;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.JdbcDataSource;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.VirtualDataSourceException;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.teiid.ServerConfig;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.teiid.TeiidDataSource;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.VirtualDataSourceConfig;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.VirtualDataSourceHandler;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.VirtualSQLDataSource;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl.AbstractVirtualDataSourceQueryServiceImpl;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl.DataSourceImpl;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl.TeiidConnectionFactoryImpl;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl.TeiidMemoryConfigImpl;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.teiid.LogConfig;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.teiid.TeiidEmbeddedServer;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.teiid.TeiidLogger;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.teiid.TranslatorConfig;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.AwsDataSourceService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JdbcDataSourceService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.VirtualReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.logging.Logger;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.translator.TranslatorException;

public class TeiidVirtualDataSourceQueryServiceImpl
extends AbstractVirtualDataSourceQueryServiceImpl {
    private static TeiidEmbeddedServer INSTANCE;
    private static ConnectorManagerRepository cmr;
    static TranslatorConfig defaultTranslatorConfig;
    static List<TranslatorConfig> translatorConfigList;
    static List<LogConfig> logConfigList;
    static List<VirtualDataSourceConfig> virtualDataSourceConfigList;
    String driverPrefix = "jdbc:teiid:";
    VirtualReportDataSourceServiceFactory virtualReportDataSourceServiceFactory;
    EngineService engineService;
    RepositoryService repositoryService;
    TeiidMemoryConfigImpl memoryConfig;
    ServerConfig ServerConfig;
    private EmbeddedConfiguration embeddedConfiguration = new EmbeddedConfiguration();
    private boolean useSubDSTableList = false;
    private Map<String, Map<String, String>> importPropertyMap;

    public VirtualReportDataSourceServiceFactory getVirtualReportDataSourceServiceFactory() {
        return this.virtualReportDataSourceServiceFactory;
    }

    public void setVirtualReportDataSourceServiceFactory(VirtualReportDataSourceServiceFactory virtualReportDataSourceServiceFactory) {
        this.virtualReportDataSourceServiceFactory = virtualReportDataSourceServiceFactory;
    }

    public EngineService getEngineService() {
        return this.engineService;
    }

    public void setEngineService(EngineService engineService) {
        this.engineService = engineService;
    }

    public Map<String, Map<String, String>> getImportPropertyMap() {
        return this.importPropertyMap;
    }

    public void setImportPropertyMap(Map<String, Map<String, String>> importPropertyMap) {
        this.importPropertyMap = importPropertyMap;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repository) {
        this.repositoryService = repository;
    }

    public TeiidMemoryConfigImpl getMemoryConfig() {
        return this.memoryConfig;
    }

    public void setMemoryConfig(TeiidMemoryConfigImpl memoryConfig) {
        this.memoryConfig = memoryConfig;
    }

    public EmbeddedConfiguration getEmbeddedConfiguration() {
        return this.embeddedConfiguration;
    }

    public void setEmbeddedConfiguration(EmbeddedConfiguration embeddedConfiguration) {
        this.embeddedConfiguration = embeddedConfiguration;
    }

    public ServerConfig getServerConfig() {
        return this.ServerConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.ServerConfig = serverConfig;
    }

    public boolean isUseSubDSTableList() {
        return this.useSubDSTableList;
    }

    public void setUseSubDSTableList(boolean useSubDSTableList) {
        this.useSubDSTableList = useSubDSTableList;
    }

    public static void setDefaultTranslatorConfig(TranslatorConfig defaultTranslatorConfig) {
        TeiidVirtualDataSourceQueryServiceImpl.defaultTranslatorConfig = defaultTranslatorConfig;
    }

    public static TranslatorConfig getDefaultTranslatorConfig() {
        return defaultTranslatorConfig;
    }

    public static void setTranslatorConfigList(List<TranslatorConfig> translatorConfigList) {
        TeiidVirtualDataSourceQueryServiceImpl.translatorConfigList = translatorConfigList;
    }

    public static List<TranslatorConfig> getTranslatorConfigList() {
        return translatorConfigList;
    }

    public static void setVirtualDataSourceConfigList(List<VirtualDataSourceConfig> virtualDataSourceConfigList) {
        TeiidVirtualDataSourceQueryServiceImpl.virtualDataSourceConfigList = virtualDataSourceConfigList;
    }

    public static List<VirtualDataSourceConfig> getVirtualDataSourceConfigList() {
        return virtualDataSourceConfigList;
    }

    public static void setLogConfigList(List<LogConfig> logConfigList) {
        TeiidVirtualDataSourceQueryServiceImpl.logConfigList = logConfigList;
    }

    public static List<LogConfig> getLogConfigList() {
        return logConfigList;
    }

    public void deployVirtualDataSource(String virtualDSName, List<ModelMetaData> modelMetaDataList) throws SQLException {
        try {
            long time = 0L;
            if (this.isDebugEnabled()) {
                this.debug("Deploy virtual data source to Teiid Server - " + virtualDSName);
                time = System.currentTimeMillis();
                if (modelMetaDataList != null) {
                    for (ModelMetaData modelMetaData : modelMetaDataList) {
                        this.debug("\t\tDeploy Model - " + modelMetaData.getName());
                    }
                }
            }
            INSTANCE.deployVDB(virtualDSName, modelMetaDataList.toArray(new ModelMetaData[modelMetaDataList.size()]));
            if (this.isDebugEnabled()) {
                this.debug("Deployment time for virtual data source, " + virtualDSName + ": " + (System.currentTimeMillis() - time) + "ms");
            }
        }
        catch (Exception ex) {
            this.debug("Teiid:  failed to deploy VDB.", ex);
            try {
                this.removeSubDataSource(virtualDSName);
            }
            catch (Exception ex2) {
                // empty catch block
            }
            VirtualDataSourceException virtualDataSourceException = new VirtualDataSourceException(ex.getMessage(), (Throwable)ex);
            virtualDataSourceException.setVirtualDataSourceID(virtualDSName);
            if (modelMetaDataList != null) {
                LinkedHashSet<String> schemas = new LinkedHashSet<String>();
                for (ModelMetaData modelMetaData : modelMetaDataList) {
                    schemas.add(modelMetaData.getName());
                }
                virtualDataSourceException.setSchemas(schemas);
            }
            throw virtualDataSourceException;
        }
    }

    @Override
    public synchronized ConnectionFactory createConnectionFactory(String virtualDSName, List<String> dataSourceNames, List<String> subDataSourceIDs, List<DataSource> subDataSources) throws Exception {
        TeiidConnectionFactoryImpl teiidConnectionFactory = null;
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        for (int i = 0; i < dataSourceNames.size(); ++i) {
            dataSourceMap.put(dataSourceNames.get(i), subDataSources.get(i));
        }
        if (!this.isVirtualDataSourceExisted(virtualDSName)) {
            this.debug("Build virtual data source METADATA - " + virtualDSName);
            ArrayList<ModelMetaData> modelMetaDataList = new ArrayList<ModelMetaData>();
            VirtualDataSourceConfig virtualDataSourceConfig = this.getVirtualDataSourceConfig(this.getParentDataSourceURI(subDataSources.get(0)));
            for (int i = 0; i < subDataSourceIDs.size(); ++i) {
                ConnectorManager cm = cmr.getConnectorManager(subDataSourceIDs.get(i));
                if (cm == null) {
                    this.debug("Teiid:  cannot find connector - " + subDataSourceIDs.get(i));
                    throw new VirtualDataSourceException("Teiid:  cannot find connector - " + subDataSourceIDs.get(i));
                }
                String translatorName = cm.getTranslatorName();
                String connectionName = subDataSourceIDs.get(i);
                Set<String> availableSchemaList = null;
                try {
                    availableSchemaList = VirtualSQLDataSource.discoverNonEmptySchemas(this.getDataSource(subDataSources.get(i)).getConnection());
                }
                catch (SQLException ex) {
                    throw new VirtualDataSourceException((Throwable)ex);
                }
                catch (Exception ex) {
                    this.debug("Unable to read the schema list from data source!");
                    throw new VirtualDataSourceException("Teiid:  cannot get the schema list for sub data source, " + subDataSources.get(i), (Throwable)ex);
                }
                if (availableSchemaList == null || availableSchemaList.size() == 0) {
                    modelMetaDataList.add(this.addModel(null, dataSourceNames.get(i), subDataSourceIDs.get(i), translatorName, connectionName));
                    continue;
                }
                for (String schemaName : availableSchemaList) {
                    String virtualSchemaName = dataSourceNames.get(i) + VirtualDataSourceHandler.getDataSourceSchemaSeparator() + schemaName;
                    if (virtualDataSourceConfig != null && virtualDataSourceConfig.isSchemaExcluded(virtualSchemaName) || !this.isSelectedSchema(schemaName, subDataSources.get(i))) continue;
                    modelMetaDataList.add(this.addModel(schemaName, dataSourceNames.get(i), subDataSourceIDs.get(i), translatorName, connectionName));
                }
            }
            if (virtualDataSourceConfig != null && virtualDataSourceConfig.getAdditionalDataSourceList() != null) {
                for (TeiidDataSource additionalDataSource : virtualDataSourceConfig.getAdditionalDataSourceList()) {
                    if (!this.isSubDataSourceExisted(additionalDataSource.getConnectorName())) {
                        cmr.addConnectorManager(additionalDataSource.getConnectorName(), additionalDataSource.getConnectorManager());
                    }
                    modelMetaDataList.addAll(additionalDataSource.getModelMetaDataList());
                }
            }
            teiidConnectionFactory = new TeiidConnectionFactoryImpl(this, virtualDSName, modelMetaDataList, dataSourceMap);
        } else {
            teiidConnectionFactory = new TeiidConnectionFactoryImpl(this, virtualDSName, null, dataSourceMap);
        }
        return teiidConnectionFactory;
    }

    @Override
    public String getAdditionalInformation(DataSource subDataSource) throws VirtualDataSourceException {
        VirtualDataSourceConfig virtualDataSourceConfig = this.getVirtualDataSourceConfig(this.getParentDataSourceURI(subDataSource));
        StringBuffer additionalInfo = new StringBuffer();
        if (virtualDataSourceConfig != null && virtualDataSourceConfig.getAdditionalDataSourceList() != null) {
            for (TeiidDataSource additionalDataSource : virtualDataSourceConfig.getAdditionalDataSourceList()) {
                additionalInfo.append(additionalDataSource.getConnectorName() + ";");
            }
        }
        return additionalInfo.toString();
    }

    @Override
    public void undeployVirtualDataSource(String virtualDSName) throws Exception {
        this.debug("Remove virtual data source - " + virtualDSName);
        INSTANCE.undeployVDB(virtualDSName);
    }

    @Override
    public boolean isSubDataSourceExisted(String subDataSourceName) {
        return cmr.getConnectorManager(subDataSourceName) != null;
    }

    @Override
    public void addSubDataSource(String subDataSourceName, DataSource subDataSource) throws Exception {
        this.debug("Add sub data source - " + subDataSourceName);
        final javax.sql.DataSource dataSource = this.getDataSource(subDataSource);
        String connectionName = subDataSourceName;
        TranslatorConfig translatorConfig = this.getTranslator(dataSource);
        ConnectorManager cm = new ConnectorManager(translatorConfig.getTranslatorName(), connectionName){

            public Object getConnectionFactory() throws TranslatorException {
                return dataSource;
            }
        };
        cm.setExecutionFactory(translatorConfig.getTranslatorFactory());
        cmr.addConnectorManager(subDataSourceName, cm);
    }

    @Override
    public void removeSubDataSource(String subDataSourceName) throws Exception {
        this.debug("Remove sub data source - " + subDataSourceName);
        cmr.removeConnectorManager(subDataSourceName);
    }

    public boolean isVirtualDataSourceExisted(String virtualDSName) {
        return INSTANCE.isVDBExisted(virtualDSName);
    }

    protected Connection createConnection(String virtualDataSourceName) throws SQLException {
        this.debug("Create Connection - " + virtualDataSourceName);
        return INSTANCE.createConnection(this.driverPrefix + virtualDataSourceName);
    }

    private boolean isSelectedSchema(String schemaName, DataSource reportDataSource) {
        Set<String> schemaSet = this.getSchemaSet(reportDataSource);
        if (schemaSet == null) {
            return true;
        }
        return schemaSet.contains(schemaName);
    }

    @Override
    public void init() {
        if (INSTANCE == null) {
            this.startServer();
        }
    }

    private void startServer() {
        this.setLogConfig();
        INSTANCE = new TeiidEmbeddedServer(this.embeddedConfiguration, this.memoryConfig, this.ServerConfig);
        cmr = new ConnectorManagerRepository();
        INSTANCE.setConnectorManagerRepository(cmr);
    }

    public static TeiidEmbeddedServer getServer() {
        return INSTANCE;
    }

    private void setLogConfig() {
        TeiidLogger logger = new TeiidLogger();
        for (LogConfig config : logConfigList) {
            logger.setLogLevel(config.getLogContext(), config.getMessageLevel());
        }
        LogManager.setLogListener((Logger)logger);
    }

    private TranslatorConfig getTranslator(javax.sql.DataSource dataSource) throws Exception {
        DatabaseMetaData metaData = dataSource.getConnection().getMetaData();
        String productName = metaData.getDatabaseProductName().toLowerCase();
        String productVersion = metaData.getDatabaseProductVersion().toLowerCase();
        this.debug("Getting translator for database " + productName + (productVersion != null ? " " + productVersion : ""));
        for (TranslatorConfig config : translatorConfigList) {
            if (productName.indexOf(config.getProductName().toLowerCase()) < 0) continue;
            if (config.getProductVersion() != null) {
                if (productVersion == null) {
                    productVersion = metaData.getDatabaseProductVersion().toLowerCase();
                    this.debug("Database Version: " + productVersion);
                }
                if (productVersion.indexOf(config.getProductVersion().toLowerCase()) < 0) continue;
            }
            config.setupTranslator();
            return config;
        }
        if (defaultTranslatorConfig != null) {
            this.debug("Teiid - cannot find matching translator for database " + productName + (productVersion != null ? " " + productVersion : "") + ".  Use default translator instead.");
            defaultTranslatorConfig.setupTranslator();
            return defaultTranslatorConfig;
        }
        this.debug("ERROR:  Teiid - cannot find matching translator for database " + productName + (productVersion != null ? " " + productVersion : ""));
        throw new VirtualDataSourceException("Teiid - cannot find matching translator for database " + productName + (productVersion != null ? " " + productVersion : ""));
    }

    private ModelMetaData addModel(String schema, String modelName, String connectorName, String translatorName, String connectionName) {
        Map<String, String> propertyMapForDataSourceModel;
        ModelMetaData model = new ModelMetaData();
        model.setModelType(Model.Type.PHYSICAL);
        Properties importProperties = new Properties();
        this.debug("Adding Model - SCHEMA = [" + schema + "], MODELNAME = [" + modelName + "], CONNECTORNAME = [" + connectionName + "], CONNECTIONNAME = [" + connectionName + "]");
        importProperties.setProperty("importer.useFullSchemaName", Boolean.FALSE.toString());
        this.debug("TEIID IMPORT PROPERTY [import.userFullSchemaName, " + Boolean.FALSE.toString() + "]");
        if (schema != null) {
            model.setName(modelName + VirtualDataSourceHandler.getDataSourceSchemaSeparator() + schema);
            importProperties.setProperty("importer.schemaPattern", schema);
            this.debug("TEIID IMPORT PROPERTY [import.chemaPattern, " + schema + "]");
        } else {
            model.setName(modelName);
        }
        if (this.importPropertyMap != null && (propertyMapForDataSourceModel = this.importPropertyMap.get(modelName)) != null) {
            for (Map.Entry<String, String> entry : propertyMapForDataSourceModel.entrySet()) {
                importProperties.setProperty(entry.getKey(), entry.getValue());
                this.debug("TEIID IMPORT PROPERTY [" + entry.getKey() + ", " + entry.getValue() + "]");
            }
        }
        model.setProperties(importProperties);
        model.addSourceMapping(connectorName, translatorName, connectionName);
        return model;
    }

    private VirtualDataSourceConfig getVirtualDataSourceConfig(String virtualDataSourceURI) {
        if (virtualDataSourceConfigList == null) {
            return null;
        }
        for (VirtualDataSourceConfig virtualDataSourceConfig : virtualDataSourceConfigList) {
            String datSourceURIInternal = this.repositoryService.transformPathToExternal(virtualDataSourceConfig.getDataSourceURI());
            this.debug("Transform LOOKUP RESOURCE from " + virtualDataSourceConfig.getDataSourceURI() + " to " + datSourceURIInternal);
            if (!virtualDataSourceURI.toLowerCase().endsWith(datSourceURIInternal.toLowerCase())) continue;
            return virtualDataSourceConfig;
        }
        return null;
    }

    private String getParentDataSourceURI(DataSource dataSource) throws VirtualDataSourceException {
        if (!(dataSource instanceof DataSourceImpl)) {
            throw new VirtualDataSourceException("Teiid Virtual Data Source Query Service - unable to generate data source from " + dataSource.getDataSourceName());
        }
        return ((DataSourceImpl)dataSource).getParentDataSource().getURIString();
    }

    protected javax.sql.DataSource getDataSource(DataSource dataSource) throws VirtualDataSourceException {
        if (!(dataSource instanceof DataSourceImpl)) {
            throw new VirtualDataSourceException("Teiid Virtual Data Source Query Service - unable to generate data source from " + dataSource.getDataSourceName());
        }
        ReportDataSourceService reportDataSourceService = null;
        reportDataSourceService = dataSource instanceof JdbcDataSource ? this.virtualReportDataSourceServiceFactory.createService(((DataSourceImpl)dataSource).getReportDataSource()) : this.engineService.createDataSourceService(((DataSourceImpl)dataSource).getReportDataSource());
        if (reportDataSourceService instanceof AwsDataSourceService) {
            return ((AwsDataSourceService)reportDataSourceService).getDataSource();
        }
        if (reportDataSourceService instanceof JdbcDataSourceService) {
            return ((JdbcDataSourceService)reportDataSourceService).getDataSource();
        }
        throw new VirtualDataSourceException("Teiid  Virtual Data Source Query Service - unsupported data source: " + dataSource.getDataSourceName());
    }

    static {
        defaultTranslatorConfig = null;
        translatorConfigList = new ArrayList<TranslatorConfig>();
        logConfigList = new ArrayList<LogConfig>();
        virtualDataSourceConfigList = new ArrayList<VirtualDataSourceConfig>();
    }
}

