/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl;

import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.DataSource;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.VirtualDataSourceException;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.VirtualSQLDataSource;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.VirtualSQLDataSourceMetaData;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl.TeiidVirtualDataSourceQueryServiceImpl;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.adminapi.impl.ModelMetaData;

public class TeiidConnectionFactoryImpl
implements VirtualSQLDataSourceMetaData {
    private TeiidVirtualDataSourceQueryServiceImpl teiidVirtualDataSourceQueryService;
    private String virtualDSID;
    private Set<String> schemas;
    private Set<String> catalogs;
    private String databaseProductName;
    private String identifierQuoteString;
    private List<ModelMetaData> modelMetaDataList;
    private Map<String, DataSource> subDataSourcesMap;

    public TeiidConnectionFactoryImpl(TeiidVirtualDataSourceQueryServiceImpl teiidVirtualDataSourceQueryService, String virtualDSID, List<ModelMetaData> modelMetaDataList, Map<String, DataSource> subDataSourcesMap) {
        this.teiidVirtualDataSourceQueryService = teiidVirtualDataSourceQueryService;
        this.subDataSourcesMap = subDataSourcesMap;
        this.virtualDSID = virtualDSID;
        this.modelMetaDataList = modelMetaDataList;
        if (modelMetaDataList != null) {
            this.schemas = new LinkedHashSet<String>();
            for (ModelMetaData modelMetaData : modelMetaDataList) {
                this.schemas.add(modelMetaData.getName());
            }
        }
        this.catalogs = new LinkedHashSet<String>();
        this.catalogs.add(virtualDSID);
        this.databaseProductName = "Teiid Embedded";
        this.identifierQuoteString = "\"";
    }

    public Connection createConnection() throws SQLException {
        VirtualDataSourceException vex = null;
        try {
            if (!this.teiidVirtualDataSourceQueryService.isVirtualDataSourceExisted(this.virtualDSID) && this.modelMetaDataList != null) {
                this.teiidVirtualDataSourceQueryService.deployVirtualDataSource(this.virtualDSID, this.modelMetaDataList);
            }
        }
        catch (Exception ex) {
            this.teiidVirtualDataSourceQueryService.debug("Teiid: deploy VDB - ", ex);
            vex = this.getVirtualDataSourceException(ex);
        }
        try {
            return this.teiidVirtualDataSourceQueryService.createConnection(this.virtualDSID);
        }
        catch (Exception ex) {
            this.teiidVirtualDataSourceQueryService.debug("Teiid:  failed to connect to VDB.", ex);
            if (vex == null) {
                vex = this.getVirtualDataSourceException(ex);
            }
            try {
                this.teiidVirtualDataSourceQueryService.removeSubDataSource(this.virtualDSID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw vex;
        }
    }

    private VirtualDataSourceException getVirtualDataSourceException(Throwable ex) {
        if (ex instanceof VirtualDataSourceException) {
            return (VirtualDataSourceException)ex;
        }
        VirtualDataSourceException virtualDataSourceException = new VirtualDataSourceException(ex);
        virtualDataSourceException.setVirtualDataSourceID(this.virtualDSID);
        virtualDataSourceException.setSchemas(this.schemas);
        return virtualDataSourceException;
    }

    @Override
    public Set<String> getSchemas() throws SQLException {
        return this.schemas;
    }

    @Override
    public Set<String> getCatalogs() throws SQLException {
        return this.catalogs;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.databaseProductName;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.identifierQuoteString;
    }

    private Connection getSubDataSourceConnection(String subDataSourceName) throws SQLException {
        return this.teiidVirtualDataSourceQueryService.getDataSource(this.subDataSourcesMap.get(subDataSourceName)).getConnection();
    }

    private Map<String, String> getPossibleDataSourceSchemaCombo(String vdsSchemaPattern) throws Exception {
        HashMap<String, String> dataSourceSchemaCombo = new HashMap<String, String>();
        for (String subDataSourceID : this.subDataSourcesMap.keySet()) {
            if (vdsSchemaPattern.equalsIgnoreCase(subDataSourceID)) {
                dataSourceSchemaCombo.put(subDataSourceID, null);
                continue;
            }
            if (!vdsSchemaPattern.startsWith(subDataSourceID + "_")) continue;
            dataSourceSchemaCombo.put(subDataSourceID, vdsSchemaPattern.substring(subDataSourceID.length() + 1));
        }
        return dataSourceSchemaCombo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getSubDSTableList(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (this.teiidVirtualDataSourceQueryService.isUseSubDSTableList()) {
            Connection conn = null;
            ResultSet rs = null;
            try {
                Map<String, String> dataSourceSchemaMap = this.getPossibleDataSourceSchemaCombo(schemaPattern);
                for (Map.Entry<String, String> entry : dataSourceSchemaMap.entrySet()) {
                    Set<String> schemaList;
                    conn = this.getSubDataSourceConnection(entry.getKey());
                    if (entry.getValue() != null && !(schemaList = VirtualSQLDataSource.discoverSchemas(conn)).contains(entry.getValue())) continue;
                    rs = conn.getMetaData().getTables(catalog, entry.getValue(), tableNamePattern, types);
                    HashSet<String> result = new HashSet<String>();
                    while (rs.next()) {
                        result.add(rs.getString("TABLE_NAME"));
                    }
                    try {
                        rs.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    HashSet<String> hashSet = result;
                    return hashSet;
                }
            }
            catch (Exception ex) {
                this.teiidVirtualDataSourceQueryService.debug("Unable to retrieve original table list.  Use the table list from VDS instead.");
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {}
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        return null;
    }
}

