/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.util.Immutables;
import org.infinispan.util.concurrent.BoundedConcurrentHashMap;
import org.infinispan.util.concurrent.ConcurrentMapFactory;

@ThreadSafe
public class DefaultDataContainer
implements DataContainer {
    final ConcurrentMap<Object, InternalCacheEntry> entries;
    InternalEntryFactory entryFactory;
    final DefaultEvictionListener evictionListener;
    private EvictionManager evictionManager;
    private PassivationManager passivator;

    public DefaultDataContainer(int concurrencyLevel) {
        this.entries = ConcurrentMapFactory.makeConcurrentMap(128, concurrencyLevel);
        this.evictionListener = null;
    }

    protected DefaultDataContainer(int concurrencyLevel, int maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy) {
        BoundedConcurrentHashMap.Eviction eviction;
        switch (policy) {
            case PIGGYBACK: 
            case DEFAULT: {
                this.evictionListener = new DefaultEvictionListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction thread policy " + (Object)((Object)strategy));
            }
        }
        switch (strategy) {
            case FIFO: 
            case UNORDERED: 
            case LRU: {
                eviction = BoundedConcurrentHashMap.Eviction.LRU;
                break;
            }
            case LIRS: {
                eviction = BoundedConcurrentHashMap.Eviction.LIRS;
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction strategy " + (Object)((Object)strategy));
            }
        }
        this.entries = new BoundedConcurrentHashMap<Object, InternalCacheEntry>(maxEntries, concurrencyLevel, eviction, this.evictionListener);
    }

    @Inject
    public void initialize(EvictionManager evictionManager, PassivationManager passivator, InternalEntryFactory entryFactory) {
        this.evictionManager = evictionManager;
        this.passivator = passivator;
        this.entryFactory = entryFactory;
    }

    public static DataContainer boundedDataContainer(int concurrencyLevel, int maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy) {
        return new DefaultDataContainer(concurrencyLevel, maxEntries, strategy, policy);
    }

    public static DataContainer unBoundedDataContainer(int concurrencyLevel) {
        return new DefaultDataContainer(concurrencyLevel);
    }

    @Override
    public InternalCacheEntry peek(Object key) {
        return (InternalCacheEntry)this.entries.get(key);
    }

    @Override
    public InternalCacheEntry get(Object k) {
        InternalCacheEntry e = this.peek(k);
        if (e != null && e.canExpire()) {
            long currentTimeMillis = System.currentTimeMillis();
            if (e.isExpired(currentTimeMillis)) {
                this.entries.remove(k);
                e = null;
            } else {
                e.touch(currentTimeMillis);
            }
        }
        return e;
    }

    @Override
    public void put(Object k, Object v, EntryVersion version, long lifespan, long maxIdle) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.get(k);
        if (e != null) {
            e.setValue(v);
            InternalCacheEntry original = e;
            e.setVersion(version);
            e = this.entryFactory.update(e, lifespan, maxIdle);
            if (original == e) {
                e.reincarnate();
            }
        } else {
            e = this.entryFactory.create(k, v, version, lifespan, maxIdle);
        }
        this.entries.put(k, e);
    }

    @Override
    public boolean containsKey(Object k) {
        InternalCacheEntry ice = this.peek(k);
        if (ice != null && ice.canExpire() && ice.isExpired(System.currentTimeMillis())) {
            this.entries.remove(k);
            ice = null;
        }
        return ice != null;
    }

    @Override
    public InternalCacheEntry remove(Object k) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.remove(k);
        return e == null || e.canExpire() && e.isExpired(System.currentTimeMillis()) ? null : e;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    @Override
    public Collection<Object> values() {
        return new Values();
    }

    @Override
    public Set<InternalCacheEntry> entrySet() {
        return new EntrySet();
    }

    @Override
    public void purgeExpired() {
        long currentTimeMillis = System.currentTimeMillis();
        Iterator purgeCandidates = this.entries.values().iterator();
        while (purgeCandidates.hasNext()) {
            InternalCacheEntry e = (InternalCacheEntry)purgeCandidates.next();
            if (!e.isExpired(currentTimeMillis)) continue;
            purgeCandidates.remove();
        }
    }

    @Override
    public Iterator<InternalCacheEntry> iterator() {
        return new EntryIterator(this.entries.values().iterator());
    }

    private static class ValueIterator
    implements Iterator<Object> {
        Iterator<InternalCacheEntry> currentIterator;

        private ValueIterator(Iterator<InternalCacheEntry> it) {
            this.currentIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            return this.currentIterator.next().getValue();
        }
    }

    private class Values
    extends AbstractCollection<Object> {
        private Values() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }
    }

    private class EntrySet
    extends AbstractSet<InternalCacheEntry> {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            InternalCacheEntry ice = (InternalCacheEntry)DefaultDataContainer.this.entries.get(e.getKey());
            if (ice == null) {
                return false;
            }
            return ice.getValue().equals(e.getValue());
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            return new ImmutableEntryIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }
    }

    public static class EntryIterator
    implements Iterator<InternalCacheEntry> {
        private final Iterator<InternalCacheEntry> it;

        EntryIterator(Iterator<InternalCacheEntry> it) {
            this.it = it;
        }

        @Override
        public InternalCacheEntry next() {
            return this.it.next();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ImmutableEntryIterator
    extends EntryIterator {
        ImmutableEntryIterator(Iterator<InternalCacheEntry> it) {
            super(it);
        }

        @Override
        public InternalCacheEntry next() {
            return Immutables.immutableInternalCacheEntry(super.next());
        }
    }

    private final class DefaultEvictionListener
    implements BoundedConcurrentHashMap.EvictionListener<Object, InternalCacheEntry> {
        private DefaultEvictionListener() {
        }

        @Override
        public void onEntryEviction(Map<Object, InternalCacheEntry> evicted) {
            DefaultDataContainer.this.evictionManager.onEntryEviction(evicted);
        }

        @Override
        public void onEntryChosenForEviction(InternalCacheEntry internalCacheEntry) {
            DefaultDataContainer.this.passivator.passivate(internalCacheEntry);
        }
    }
}

