/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.configuration.cache.CustomInterceptorsConfigurationBuilder;
import org.infinispan.configuration.cache.DataContainerConfigurationBuilder;
import org.infinispan.configuration.cache.DeadlockDetectionConfigurationBuilder;
import org.infinispan.configuration.cache.EvictionConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.cache.InvocationBatchingConfigurationBuilder;
import org.infinispan.configuration.cache.JMXStatisticsConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfigurationBuilder;
import org.infinispan.configuration.cache.StoreAsBinaryConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.cache.UnsafeConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningConfigurationBuilder;

public class ConfigurationBuilder
implements ConfigurationChildBuilder {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private final ClusteringConfigurationBuilder clustering = new ClusteringConfigurationBuilder(this);
    private final CustomInterceptorsConfigurationBuilder customInterceptors = new CustomInterceptorsConfigurationBuilder(this);
    private final DataContainerConfigurationBuilder dataContainer = new DataContainerConfigurationBuilder(this);
    private final DeadlockDetectionConfigurationBuilder deadlockDetection = new DeadlockDetectionConfigurationBuilder(this);
    private final EvictionConfigurationBuilder eviction = new EvictionConfigurationBuilder(this);
    private final ExpirationConfigurationBuilder expiration = new ExpirationConfigurationBuilder(this);
    private final IndexingConfigurationBuilder indexing = new IndexingConfigurationBuilder(this);
    private final InvocationBatchingConfigurationBuilder invocationBatching = new InvocationBatchingConfigurationBuilder(this);
    private final JMXStatisticsConfigurationBuilder jmxStatistics = new JMXStatisticsConfigurationBuilder(this);
    private final LoadersConfigurationBuilder loaders = new LoadersConfigurationBuilder(this);
    private final LockingConfigurationBuilder locking = new LockingConfigurationBuilder(this);
    private final StoreAsBinaryConfigurationBuilder storeAsBinary = new StoreAsBinaryConfigurationBuilder(this);
    private final TransactionConfigurationBuilder transaction = new TransactionConfigurationBuilder(this);
    private final VersioningConfigurationBuilder versioning = new VersioningConfigurationBuilder(this);
    private final UnsafeConfigurationBuilder unsafe = new UnsafeConfigurationBuilder(this);

    public ConfigurationBuilder classLoader(ClassLoader cl) {
        this.classLoader = cl;
        return this;
    }

    ClassLoader classLoader() {
        return this.classLoader;
    }

    @Override
    public ClusteringConfigurationBuilder clustering() {
        return this.clustering;
    }

    @Override
    public CustomInterceptorsConfigurationBuilder customInterceptors() {
        return this.customInterceptors;
    }

    @Override
    public DataContainerConfigurationBuilder dataContainer() {
        return this.dataContainer;
    }

    @Override
    public DeadlockDetectionConfigurationBuilder deadlockDetection() {
        return this.deadlockDetection;
    }

    @Override
    public EvictionConfigurationBuilder eviction() {
        return this.eviction;
    }

    @Override
    public ExpirationConfigurationBuilder expiration() {
        return this.expiration;
    }

    @Override
    public IndexingConfigurationBuilder indexing() {
        return this.indexing;
    }

    @Override
    public InvocationBatchingConfigurationBuilder invocationBatching() {
        return this.invocationBatching;
    }

    @Override
    public JMXStatisticsConfigurationBuilder jmxStatistics() {
        return this.jmxStatistics;
    }

    @Override
    public StoreAsBinaryConfigurationBuilder storeAsBinary() {
        return this.storeAsBinary;
    }

    @Override
    public LoadersConfigurationBuilder loaders() {
        return this.loaders;
    }

    @Override
    public LockingConfigurationBuilder locking() {
        return this.locking;
    }

    @Override
    public TransactionConfigurationBuilder transaction() {
        return this.transaction;
    }

    @Override
    public VersioningConfigurationBuilder versioning() {
        return this.versioning;
    }

    @Override
    public UnsafeConfigurationBuilder unsafe() {
        return this.unsafe;
    }

    public void validate() {
        for (AbstractConfigurationChildBuilder validatable : Arrays.asList(this.clustering, this.dataContainer, this.deadlockDetection, this.eviction, this.expiration, this.indexing, this.invocationBatching, this.jmxStatistics, this.loaders, this.locking, this.storeAsBinary, this.transaction, this.versioning, this.unsafe)) {
            validatable.validate();
        }
    }

    @Override
    public Configuration build() {
        this.validate();
        return new Configuration(this.clustering.create(), this.customInterceptors.create(), this.dataContainer.create(), this.deadlockDetection.create(), this.eviction.create(), this.expiration.create(), this.indexing.create(), this.invocationBatching.create(), this.jmxStatistics.create(), this.loaders.create(), this.locking.create(), this.storeAsBinary.create(), this.transaction.create(), this.unsafe.create(), this.versioning.create(), this.classLoader);
    }

    public ConfigurationBuilder read(Configuration template) {
        this.classLoader = template.classLoader();
        this.clustering.read(template.clustering());
        this.customInterceptors.read(template.customInterceptors());
        this.dataContainer.read(template.dataContainer());
        this.deadlockDetection.read(template.deadlockDetection());
        this.eviction.read(template.eviction());
        this.expiration.read(template.expiration());
        this.indexing.read(template.indexing());
        this.invocationBatching.read(template.invocationBatching());
        this.jmxStatistics.read(template.jmxStatistics());
        this.loaders.read(template.loaders());
        this.locking.read(template.locking());
        this.storeAsBinary.read(template.storeAsBinary());
        this.transaction.read(template.transaction());
        this.unsafe.read(template.unsafe());
        this.versioning.read(template.versioning());
        return this;
    }

    public String toString() {
        return "ConfigurationBuilder{classLoader=" + this.classLoader + ", clustering=" + this.clustering + ", customInterceptors=" + this.customInterceptors + ", dataContainer=" + this.dataContainer + ", deadlockDetection=" + this.deadlockDetection + ", eviction=" + this.eviction + ", expiration=" + this.expiration + ", indexing=" + this.indexing + ", invocationBatching=" + this.invocationBatching + ", jmxStatistics=" + this.jmxStatistics + ", loaders=" + this.loaders + ", locking=" + this.locking + ", storeAsBinary=" + this.storeAsBinary + ", transaction=" + this.transaction + ", versioning=" + this.versioning + ", unsafe=" + this.unsafe + '}';
    }
}

