/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom.wrappers;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.wrappers.GenericDOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JaxpDOMParser
extends GenericDOMParser {
    private DocumentBuilder builder;

    public JaxpDOMParser() throws XOMException {
        this(false);
    }

    public JaxpDOMParser(boolean bl) throws XOMException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            try {
                documentBuilderFactory.setAttribute("http://xml.org/sax/features/validation", new Boolean(bl));
                documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(bl));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XOMException(parserConfigurationException, "Error creating parser");
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new XOMException(factoryConfigurationError, "Error creating parser");
        }
        this.builder.setErrorHandler(this);
        this.document = this.builder.newDocument();
    }

    protected Document parseInputSource(InputSource inputSource) throws XOMException {
        this.prepareParse();
        try {
            Document document = this.builder.parse(inputSource);
            this.handleErrors();
            return document;
        }
        catch (SAXException sAXException) {
            this.handleErrors();
            throw new XOMException(sAXException, "Document parse failed");
        }
        catch (IOException iOException) {
            this.handleErrors();
            throw new XOMException(iOException, "Document parse failed");
        }
    }
}

