/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.MissingResourceException;
import nux.xom.pool.Pool;
import nux.xom.pool.PoolConfig;
import nux.xom.pool.ResourceResolver;
import nux.xom.pool.XQueryFactory;
import nux.xom.xquery.XQuery;
import nux.xom.xquery.XQueryException;

public class XQueryPool {
    public static final XQueryPool GLOBAL_POOL = new XQueryPool();
    private final XQueryFactory factory;
    private final Map entries;

    public XQueryPool() {
        this(new PoolConfig(), new XQueryFactory());
    }

    public XQueryPool(PoolConfig config, XQueryFactory factory) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.factory = factory;
        this.entries = Pool.createPool(config);
    }

    public XQuery getXQuery(File query) throws XQueryException, IOException {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        File key = query;
        XQuery xquery = (XQuery)this.entries.get(key);
        if (xquery == null) {
            xquery = this.factory.createXQuery(query);
            this.entries.put(key, xquery);
        }
        return xquery;
    }

    public XQuery getXQuery(File query, URI baseURI) throws XQueryException, IOException {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = query;
        objectArray[1] = baseURI;
        Object key = Pool.createHashKeys(objectArray);
        XQuery xquery = (XQuery)this.entries.get(key);
        if (xquery == null) {
            xquery = this.factory.createXQuery(query, baseURI);
            this.entries.put(key, xquery);
        }
        return xquery;
    }

    public XQuery getXQuery(String query, URI baseURI) throws XQueryException {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        Object key = baseURI == null ? query : Pool.createHashKeys(new Object[]{query, baseURI});
        XQuery xquery = (XQuery)this.entries.get(key);
        if (xquery == null) {
            xquery = this.factory.createXQuery(query, baseURI);
            this.entries.put(key, xquery);
        }
        return xquery;
    }

    public XQuery getXQuery(ResourceResolver resolver, String resourceName, URI baseURI) throws XQueryException, IOException, MissingResourceException {
        if (resolver == null) {
            throw new IllegalArgumentException("resolver must not be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName must not be null");
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = resourceName;
        objectArray[1] = baseURI;
        Object key = Pool.createHashKeys(objectArray);
        XQuery xquery = (XQuery)this.entries.get(key);
        if (xquery == null) {
            InputStream query = resolver.getResourceAsStream(resourceName);
            if (query == null) {
                throw new MissingResourceException("Resource '" + resourceName + "' could not be found by resolver: " + resolver.getClass().getName(), resolver.getClass().getName(), resourceName);
            }
            xquery = this.factory.createXQuery(query, baseURI);
            this.entries.put(key, xquery);
        }
        return xquery;
    }
}

