/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import nu.xom.Node;
import nux.xom.pool.PoolConfig;
import nux.xom.pool.PoolValidatingKey;
import nux.xom.pool.XOMUtil;
import org.apache.lucene.index.memory.MemoryIndex;

final class Pool
implements Map {
    private final SoftLRUHashMap child;
    private final ReferenceQueue queue;
    private long totalSize = 0L;
    private final long maxIdleTime;
    private final long maxLifeTime;
    private final long capacity;
    private final boolean fileMonitoring;
    private static final Timer SWEEPER = new Timer(true);
    private static final boolean DEBUG = XOMUtil.getSystemProperty("nux.xom.pool.Pool.debug", false);

    static Object createHashKeys(Object[] keys) {
        return new HashKeys(keys);
    }

    static Map createPool(PoolConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        int maxEntries = config.getMaxEntries();
        if (config.getCapacity() <= 0L || config.getMaxIdleTime() <= 0L || config.getMaxLifeTime() <= 0L) {
            maxEntries = 0;
        }
        if (maxEntries > 0) {
            return new Pool(config);
        }
        return Collections.synchronizedMap(new LRUHashMap(Math.abs(maxEntries), null, null));
    }

    private Pool(PoolConfig config) {
        this.child = new SoftLRUHashMap(this, config.getMaxEntries());
        this.capacity = config.getCapacity();
        this.fileMonitoring = config.getFileMonitoring();
        this.maxIdleTime = Math.max(100L, config.getMaxIdleTime());
        this.maxLifeTime = Math.max(100L, config.getMaxLifeTime());
        long t = Math.min(this.maxIdleTime, this.maxLifeTime);
        t = Math.min(config.getInvalidationPeriod(), t);
        if (t == Long.MAX_VALUE) {
            t = -1L;
        }
        if (t >= 0L) {
            t = Math.max(100L, t);
        }
        ReferenceQueue referenceQueue = this.queue = t > 0L ? new ReferenceQueue() : null;
        if (t > 0L) {
            SWEEPER.schedule((TimerTask)new SweepTask(this), t, t);
        }
    }

    public synchronized void clear() {
        this.evictStaleEntries();
        this.child.clear();
        this.totalSize = 0L;
    }

    public synchronized Object get(Object key) {
        this.evictStaleEntries();
        SoftValue ref = (SoftValue)this.child.get(key);
        return SoftValue.unwrap(ref, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        int keySize;
        int valueSize;
        Pool pool = this;
        synchronized (pool) {
            this.evictStaleEntries();
        }
        int size = 0;
        if (value != null && this.capacity != Long.MAX_VALUE && (long)(size += (valueSize = Pool.getMemorySize(value)) + (keySize = Pool.getMemorySize(key))) > this.capacity) {
            value = null;
        }
        Pool pool2 = this;
        synchronized (pool2) {
            SoftValue old;
            if (value != null) {
                SoftValue ref = new SoftValue(key, value, this.queue, size);
                old = this.child.put(key, ref);
                this.totalSize += (long)size;
            } else {
                old = (SoftValue)this.child.remove(key);
            }
            Object result = SoftValue.unwrap(old, true);
            if (old != null) {
                this.evictEntry(key, old, "PUT");
            }
            if (value != null && this.totalSize > this.capacity) {
                this.evictExcessMemoryEntries();
            }
            return result;
        }
    }

    public Object remove(Object key) {
        return this.put(key, (Object)null);
    }

    public synchronized boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public synchronized int size() {
        return this.child.size();
    }

    public synchronized boolean isEmpty() {
        return this.child.isEmpty();
    }

    public synchronized Set keySet() {
        return this.child.keySet();
    }

    public void putAll(Map src) {
        Iterator iter = src.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private void evictEntry(Object key, SoftValue ref, String msg) {
        ref.remove();
        this.totalSize -= (long)ref.size;
        if (DEBUG) {
            String str = String.valueOf(key);
            if (str.length() > 35) {
                str = String.valueOf(str.substring(0, 32)) + "...";
            }
            System.err.println("*******" + msg + " EVICTED=" + str + ", size()=" + this.child.size() + ", MB=" + (float)this.totalSize / 1048576.0f);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void evictStaleEntries() {
        if (this.queue != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            if (SoftValue.access$4(ref)) continue;
            this.child.remove(SoftValue.access$5(ref));
            this.evictEntry(SoftValue.access$5(ref), ref, "GC");
lbl7:
            // 3 sources

            ** while ((ref = (SoftValue)this.queue.poll()) != null)
        }
lbl8:
        // 1 sources

    }

    private void evictInvalidEntries() {
        Iterator iter = this.child.entrySet().iterator();
        long now = System.currentTimeMillis();
        long idle = this.maxIdleTime - now;
        long life = this.maxLifeTime - now;
        while (iter.hasNext()) {
            boolean isValid;
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            SoftValue ref = (SoftValue)entry.getValue();
            String msg = null;
            boolean bl = isValid = ref.lastAccessTime + idle > 0L;
            if (!isValid) {
                msg = "INVALID (maxIdleTime)";
            }
            if (isValid) {
                boolean bl2 = isValid = ref.insertionTime + life > 0L;
                if (!isValid) {
                    msg = "INVALID (maxLifeTime)";
                }
            }
            if (isValid && key instanceof PoolValidatingKey && !(isValid = ((PoolValidatingKey)key).isValid())) {
                msg = "INVALID (PoolValidatingKey)";
            }
            if (isValid && this.fileMonitoring) {
                File file = null;
                if (key instanceof File) {
                    file = (File)key;
                } else if (key instanceof HashKeys) {
                    file = ((HashKeys)key).getFile();
                }
                if (file != null) {
                    long lastModified = file.lastModified();
                    boolean bl3 = isValid = lastModified != 0L && lastModified <= ref.insertionTime;
                    if (!isValid) {
                        msg = "INVALID (fileChange)";
                    }
                }
            }
            if (isValid) continue;
            iter.remove();
            this.evictEntry(key, ref, msg);
        }
    }

    private void evictExcessMemoryEntries() {
        Iterator iter = this.child.entrySet().iterator();
        while (this.totalSize > this.capacity && iter.hasNext()) {
            Map.Entry entry = iter.next();
            iter.remove();
            this.evictEntry(entry.getKey(), (SoftValue)entry.getValue(), "MEMORY");
        }
    }

    private static int getMemorySize(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof byte[]) {
            return ((byte[])value).length;
        }
        if (value instanceof Node) {
            return XOMUtil.getMemorySize((Node)value);
        }
        if (value instanceof CharSequence) {
            return 2 * ((CharSequence)value).length();
        }
        if (value instanceof HashKeys) {
            value = ((HashKeys)value).keys;
        } else if (value instanceof Collection) {
            value = ((Collection)value).toArray();
        }
        if (value instanceof Object[]) {
            Object[] arr = value;
            int size = 16 + 4 * arr.length;
            int i = arr.length;
            while (--i >= 0) {
                size += Pool.getMemorySize(arr[i]);
            }
            return size;
        }
        if (value instanceof MemoryIndex) {
            return ((MemoryIndex)value).getMemorySize();
        }
        return 0;
    }

    private static class LRUHashMap
    extends LinkedHashMap {
        private final int maxSize;

        private LRUHashMap(int maxSize) {
            super(1, 0.75f, true);
            this.maxSize = maxSize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }

        /* synthetic */ LRUHashMap(int n, LRUHashMap lRUHashMap, LRUHashMap lRUHashMap2) {
            this(n);
        }
    }

    private static final class SoftLRUHashMap
    extends LRUHashMap {
        private final Pool pool;

        private SoftLRUHashMap(Pool pool, int maxEntries) {
            super(maxEntries);
            this.pool = pool;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            if (super.removeEldestEntry(eldest)) {
                this.remove(eldest.getKey());
                this.pool.evictEntry(eldest.getKey(), (SoftValue)eldest.getValue(), "MAXENTRIES");
            }
            return false;
        }
    }

    private static final class SoftValue
    extends SoftReference {
        private Object key;
        private final long insertionTime;
        private long lastAccessTime;
        private final int size;
        private static final Object REMOVED = new Object();

        private SoftValue(Object key, Object value, ReferenceQueue queue, int size) {
            super(value, queue);
            this.key = key;
            this.lastAccessTime = this.insertionTime = System.currentTimeMillis();
            this.size = size;
        }

        private static Object unwrap(SoftValue ref, boolean remove) {
            if (ref == null) {
                return null;
            }
            Object value = ref.get();
            if (remove) {
                ref.remove();
            } else {
                ref.lastAccessTime = System.currentTimeMillis();
            }
            return value;
        }

        private boolean isRemoved() {
            return this.key == REMOVED;
        }

        private void remove() {
            this.clear();
            this.key = REMOVED;
        }

        public String toString() {
            return "key=" + this.key + ", val=" + this.get();
        }

        static /* synthetic */ boolean access$4(SoftValue softValue) {
            return softValue.isRemoved();
        }

        static /* synthetic */ Object access$5(SoftValue softValue) {
            return softValue.key;
        }
    }

    private static final class SweepTask
    extends TimerTask {
        private final WeakReference poolRef;

        private SweepTask(Pool pool) {
            this.poolRef = new WeakReference<Pool>(pool);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: {
                try {
                    Pool pool = (Pool)this.poolRef.get();
                    if (pool != null) {
                        if (DEBUG) {
                            System.err.println("############### Pool.SweepTask running...");
                        }
                        long now = DEBUG ? System.currentTimeMillis() : 0L;
                        Pool pool2 = pool;
                        synchronized (pool2) {
                            pool.evictStaleEntries();
                            pool.evictInvalidEntries();
                        }
                        if (DEBUG) {
                            System.err.println("Pool.SweepTask took ms=" + (System.currentTimeMillis() - now));
                        }
                        break block8;
                    }
                    this.cancel();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (!DEBUG) break block8;
                    System.exit(-1);
                }
            }
        }
    }

    private static final class HashKeys {
        private final Object[] keys;

        private HashKeys(Object[] keys) {
            if (keys == null) {
                throw new IllegalArgumentException("keys must not be null");
            }
            this.keys = keys;
        }

        public final boolean equals(Object other) {
            if (other instanceof HashKeys) {
                return HashKeys.eq(this.keys, ((HashKeys)other).keys);
            }
            return false;
        }

        public final int hashCode() {
            int hash = 1;
            Object[] k = this.keys;
            int i = k.length;
            while (--i >= 0) {
                hash *= 31;
                if (k[i] == null) continue;
                hash += k[i].hashCode();
            }
            return hash;
        }

        private static boolean eq(Object[] k1, Object[] k2) {
            int len = k1.length;
            if (len != k2.length) {
                return false;
            }
            int i = 0;
            while (i < len) {
                Object x = k1[i];
                Object y = k2[i];
                if (!(x == y || x != null && y != null && x.equals(y))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public File getFile() {
            if (this.keys.length > 0 && this.keys[0] instanceof File) {
                return (File)this.keys[0];
            }
            return null;
        }

        public String toString() {
            return Arrays.asList(this.keys).toString();
        }
    }
}

