/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nux.xom.io.NamespacesInScope;
import nux.xom.io.StreamingSerializer;
import nux.xom.io.StreamingVerifier;

final class StreamingStaxSerializer
implements StreamingSerializer {
    private final XMLStreamWriter writer;
    private final StreamingVerifier verifier = new StreamingVerifier();
    private final NamespacesInScope namespaces = new NamespacesInScope();
    private static final boolean DEBUG = false;
    private static SoftReference ENCODING_METHODS = new SoftReference<Object>(null);
    private static final Method NOT_AVAILABLE;

    StreamingStaxSerializer(XMLStreamWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("XMLStreamWriter must not be null");
        }
        if (!StreamingStaxSerializer.isNamespaceAware(writer)) {
            throw new IllegalArgumentException("XMLStreamWriter must be namespace aware");
        }
        this.writer = writer;
    }

    StreamingStaxSerializer(OutputStream out, String encoding) throws XMLStreamException {
        this(XMLOutputFactory.newInstance().createXMLStreamWriter(out, encoding));
    }

    private void reset() {
        this.verifier.reset();
        this.namespaces.reset();
    }

    public void flush() throws IOException {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            StreamingStaxSerializer.wrapException(e);
        }
    }

    public void writeStartTag(Element elem) throws IOException {
        this.verifier.writeStartTag(elem);
        this.namespaces.push();
        try {
            this.writer.writeStartElement(elem.getNamespacePrefix(), elem.getLocalName(), elem.getNamespaceURI());
        }
        catch (XMLStreamException e) {
            StreamingStaxSerializer.wrapException(e);
        }
        this.writeAttributes(elem);
        this.writeNamespaceDeclarations(elem);
    }

    private void writeNamespaceDeclarations(Element elem) throws IOException {
        int count = elem.getNamespaceDeclarationCount();
        for (int i = 0; i < count; ++i) {
            String uri;
            String prefix = elem.getNamespacePrefix(i);
            if (!this.namespaces.addIfAbsent(prefix, uri = elem.getNamespaceURI(prefix))) continue;
            try {
                this.writer.writeNamespace(prefix, uri);
                continue;
            }
            catch (XMLStreamException e) {
                StreamingStaxSerializer.wrapException(e);
            }
        }
    }

    private void writeAttributes(Element elem) throws IOException {
        int count = elem.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            Attribute attr = elem.getAttribute(i);
            try {
                this.writer.writeAttribute(attr.getNamespacePrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getValue());
                continue;
            }
            catch (XMLStreamException e) {
                StreamingStaxSerializer.wrapException(e);
            }
        }
    }

    public void writeEndTag() throws IOException {
        this.verifier.writeEndTag();
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            StreamingStaxSerializer.wrapException(e);
        }
        this.namespaces.pop();
    }

    public void write(Document doc) throws IOException {
        this.writeXMLDeclaration();
        for (int i = 0; i < doc.getChildCount(); ++i) {
            this.writeChild(doc.getChild(i));
        }
        this.writeEndDocument();
    }

    public void write(Element element) throws IOException {
        this.writeStartTag(element);
        for (int i = 0; i < element.getChildCount(); ++i) {
            this.writeChild(element.getChild(i));
        }
        this.writeEndTag();
    }

    public void write(Text text) throws IOException {
        this.verifier.write(text);
        String value = text.getValue();
        if (value.length() > 0) {
            try {
                this.writer.writeCharacters(value);
            }
            catch (XMLStreamException e) {
                StreamingStaxSerializer.wrapException(e);
            }
        }
    }

    public void write(Comment comment) throws IOException {
        this.verifier.write(comment);
        try {
            this.writer.writeComment(comment.getValue());
        }
        catch (XMLStreamException e) {
            StreamingStaxSerializer.wrapException(e);
        }
    }

    public void write(ProcessingInstruction instruction) throws IOException {
        this.verifier.write(instruction);
        try {
            this.writer.writeProcessingInstruction(instruction.getTarget(), instruction.getValue());
        }
        catch (XMLStreamException e) {
            StreamingStaxSerializer.wrapException(e);
        }
    }

    public void write(DocType docType) throws IOException {
        this.verifier.write(docType);
        try {
            this.writer.writeDTD(docType.toXML());
        }
        catch (XMLStreamException e) {
            StreamingStaxSerializer.wrapException(e);
        }
    }

    public void writeEndDocument() throws IOException {
        int i = this.verifier.depth();
        while (--i >= 0) {
            this.writeEndTag();
        }
        this.verifier.writeEndDocument();
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            StreamingStaxSerializer.wrapException(e);
        }
        this.flush();
        this.reset();
    }

    public void writeXMLDeclaration() throws IOException {
        this.verifier.writeXMLDeclaration();
        this.reset();
        this.verifier.writeXMLDeclaration();
        try {
            this.writer.writeStartDocument(this.getEncoding(), "1.0");
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            StreamingStaxSerializer.wrapException(e);
        }
    }

    private void writeChild(Node node) throws IOException {
        if (node instanceof Element) {
            this.write((Element)node);
        } else if (node instanceof Text) {
            this.write((Text)node);
        } else if (node instanceof Comment) {
            this.write((Comment)node);
        } else if (node instanceof ProcessingInstruction) {
            this.write((ProcessingInstruction)node);
        } else if (node instanceof DocType) {
            this.write((DocType)node);
        } else {
            throw new IllegalAddException("Cannot write node type: " + node);
        }
    }

    private static boolean isNamespaceAware(XMLStreamWriter writer) {
        return true;
    }

    private static void wrapException(Throwable t) throws IOException {
        IOException ex = new IOException();
        ex.initCause(t);
        throw ex;
    }

    private String getEncoding() {
        Method method;
        Map<String, Method> methods = (Map<String, Method>)ENCODING_METHODS.get();
        if (methods == null) {
            methods = Collections.synchronizedMap(new HashMap());
            ENCODING_METHODS = new SoftReference(methods);
        }
        if ((method = (Method)methods.get(this.writer.getClass().getName())) == null) {
            method = NOT_AVAILABLE;
            try {
                method = this.writer.getClass().getMethod("getEncoding", null);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            methods.put(this.writer.getClass().getName(), method);
        }
        String encoding = null;
        if (method != null && method != NOT_AVAILABLE) {
            try {
                encoding = (String)method.invoke((Object)this.writer, null);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return encoding;
    }

    static {
        try {
            NOT_AVAILABLE = Object.class.getMethod("wait", null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

