/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.teiid.adminapi.AdminPlugin;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDBImport;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.EntryMetaData;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.types.XMLType;
import org.xml.sax.SAXException;

public class VDBMetadataParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VDBMetaData unmarshell(InputStream content) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLType.getXmlInputFactory();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(content);
        try {
            if (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case VDB: {
                        VDBMetaData vdb = new VDBMetaData();
                        Properties props = VDBMetadataParser.getAttributes(reader);
                        vdb.setName(props.getProperty(Element.NAME.getLocalName()));
                        vdb.setVersion(Integer.parseInt(props.getProperty(Element.VERSION.getLocalName())));
                        VDBMetadataParser.parseVDB(reader, vdb);
                        VDBMetaData vDBMetaData = vdb;
                        return vDBMetaData;
                    }
                }
                throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element1", new Object[]{reader.getName(), Element.VDB.getLocalName()}), reader.getLocation());
            }
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                Logger.getLogger(VDBMetadataParser.class.getName()).log(Level.FINE, "Exception closing vdb stream", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validate(InputStream content) throws SAXException, IOException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(VDBMetaData.class.getResource("/vdb-deployer.xsd"));
            Validator v = schema.newValidator();
            v.validate(new StreamSource(content));
        }
        finally {
            content.close();
        }
    }

    private static void parseVDB(XMLStreamReader reader, VDBMetaData vdb) throws XMLStreamException {
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    vdb.setDescription(reader.getElementText());
                    continue block9;
                }
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, vdb);
                    continue block9;
                }
                case MODEL: {
                    ModelMetaData model = new ModelMetaData();
                    VDBMetadataParser.parseModel(reader, model);
                    vdb.addModel(model);
                    continue block9;
                }
                case TRANSLATOR: {
                    VDBTranslatorMetaData translator = new VDBTranslatorMetaData();
                    VDBMetadataParser.parseTranslator(reader, translator);
                    vdb.addOverideTranslator(translator);
                    continue block9;
                }
                case DATA_ROLE: {
                    DataPolicyMetadata policy = new DataPolicyMetadata();
                    VDBMetadataParser.parseDataRole(reader, policy);
                    vdb.addDataPolicy(policy);
                    continue block9;
                }
                case IMPORT_VDB: {
                    VDBImportMetadata vdbImport = new VDBImportMetadata();
                    Properties props = VDBMetadataParser.getAttributes(reader);
                    vdbImport.setName(props.getProperty(Element.NAME.getLocalName()));
                    vdbImport.setVersion(Integer.parseInt(props.getProperty(Element.VERSION.getLocalName())));
                    vdbImport.setImportDataPolicies(Boolean.parseBoolean(props.getProperty(Element.IMPORT_POLICIES.getLocalName(), "true")));
                    vdb.getVDBImports().add(vdbImport);
                    VDBMetadataParser.ignoreTillEnd(reader);
                    continue block9;
                }
                case ENTRY: {
                    EntryMetaData entry = new EntryMetaData();
                    VDBMetadataParser.parseEntry(reader, entry);
                    vdb.getEntries().add(entry);
                    continue block9;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element5", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PROPERTY.getLocalName(), Element.MODEL.getLocalName(), Element.TRANSLATOR.getLocalName(), Element.DATA_ROLE.getLocalName()}), reader.getLocation());
        }
    }

    private static void ignoreTillEnd(XMLStreamReader reader) throws XMLStreamException {
        while (reader.nextTag() != 2) {
        }
    }

    private static void parseProperty(XMLStreamReader reader, AdminObjectImpl anObj) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            String key = null;
            String value = null;
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                if (attrName.equals(Element.NAME.getLocalName())) {
                    key = attrValue;
                }
                if (!attrName.equals(Element.VALUE.getLocalName())) continue;
                value = attrValue;
            }
            anObj.addProperty(key, value);
        }
        VDBMetadataParser.ignoreTillEnd(reader);
    }

    private static void parseDataRole(XMLStreamReader reader, DataPolicyMetadata policy) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        policy.setName(props.getProperty(Element.NAME.getLocalName()));
        policy.setAnyAuthenticated(Boolean.parseBoolean(props.getProperty(Element.DATA_ROLE_ANY_ATHENTICATED_ATTR.getLocalName())));
        policy.setAllowCreateTemporaryTables(Boolean.parseBoolean(props.getProperty(Element.DATA_ROLE_ALLOW_TEMP_TABLES_ATTR.getLocalName())));
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    policy.setDescription(reader.getElementText());
                    continue block5;
                }
                case PERMISSION: {
                    DataPolicyMetadata.PermissionMetaData permission = new DataPolicyMetadata.PermissionMetaData();
                    VDBMetadataParser.parsePermission(reader, permission);
                    policy.addPermission(permission);
                    continue block5;
                }
                case MAPPED_ROLE_NAME: {
                    policy.addMappedRoleName(reader.getElementText());
                    continue block5;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element2", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PERMISSION.getLocalName(), Element.MAPPED_ROLE_NAME.getLocalName()}), reader.getLocation());
        }
    }

    private static void parsePermission(XMLStreamReader reader, DataPolicyMetadata.PermissionMetaData permission) throws XMLStreamException {
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case RESOURCE_NAME: {
                    permission.setResourceName(reader.getElementText());
                    continue block10;
                }
                case ALLOW_ALTER: {
                    permission.setAllowAlter(Boolean.parseBoolean(reader.getElementText()));
                    continue block10;
                }
                case ALLOW_CREATE: {
                    permission.setAllowCreate(Boolean.parseBoolean(reader.getElementText()));
                    continue block10;
                }
                case ALLOW_LANGUAGE: {
                    permission.setAllowLanguage(Boolean.parseBoolean(reader.getElementText()));
                    continue block10;
                }
                case ALLOW_DELETE: {
                    permission.setAllowDelete(Boolean.parseBoolean(reader.getElementText()));
                    continue block10;
                }
                case ALLOW_EXECUTE: {
                    permission.setAllowExecute(Boolean.parseBoolean(reader.getElementText()));
                    continue block10;
                }
                case ALLOW_READ: {
                    permission.setAllowRead(Boolean.parseBoolean(reader.getElementText()));
                    continue block10;
                }
                case ALLOW_UPADTE: {
                    permission.setAllowUpdate(Boolean.parseBoolean(reader.getElementText()));
                    continue block10;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element7", new Object[]{reader.getName(), Element.RESOURCE_NAME.getLocalName(), Element.ALLOW_ALTER.getLocalName(), Element.ALLOW_CREATE.getLocalName(), Element.ALLOW_DELETE.getLocalName(), Element.ALLOW_EXECUTE.getLocalName(), Element.ALLOW_READ.getLocalName(), Element.ALLOW_UPADTE, Element.ALLOW_LANGUAGE}), reader.getLocation());
        }
    }

    private static void parseTranslator(XMLStreamReader reader, VDBTranslatorMetaData translator) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        translator.setName(props.getProperty(Element.NAME.getLocalName()));
        translator.setType(props.getProperty(Element.TYPE.getLocalName()));
        translator.setDescription(props.getProperty(Element.DESCRIPTION.getLocalName()));
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, translator);
                    continue block3;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element1", new Object[]{reader.getName(), Element.PROPERTY.getLocalName()}), reader.getLocation());
        }
    }

    private static void parseEntry(XMLStreamReader reader, EntryMetaData entry) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        entry.setPath(props.getProperty(Element.PATH.getLocalName()));
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    entry.setDescription(reader.getElementText());
                    continue block4;
                }
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, entry);
                    continue block4;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element2", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PROPERTY.getLocalName()}));
        }
    }

    private static void parseModel(XMLStreamReader reader, ModelMetaData model) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        model.setName(props.getProperty(Element.NAME.getLocalName()));
        model.setModelType(props.getProperty(Element.TYPE.getLocalName(), "PHYSICAL"));
        model.setVisible(Boolean.parseBoolean(props.getProperty(Element.VISIBLE.getLocalName(), "true")));
        model.setPath(props.getProperty(Element.PATH.getLocalName()));
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    model.setDescription(reader.getElementText());
                    continue block7;
                }
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, model);
                    continue block7;
                }
                case SOURCE: {
                    Properties sourceProps = VDBMetadataParser.getAttributes(reader);
                    String name = sourceProps.getProperty(Element.NAME.getLocalName());
                    String translatorName = sourceProps.getProperty(Element.SOURCE_TRANSLATOR_NAME_ATTR.getLocalName());
                    String connectionName = sourceProps.getProperty(Element.SOURCE_CONNECTION_JNDI_NAME_ATTR.getLocalName());
                    model.addSourceMapping(name, translatorName, connectionName);
                    VDBMetadataParser.ignoreTillEnd(reader);
                    continue block7;
                }
                case VALIDATION_ERROR: {
                    Properties validationProps = VDBMetadataParser.getAttributes(reader);
                    String msg = reader.getElementText();
                    String severity = validationProps.getProperty(Element.VALIDATION_SEVERITY_ATTR.getLocalName());
                    String path = validationProps.getProperty(Element.PATH.getLocalName());
                    ModelMetaData.Message ve = new ModelMetaData.Message(ModelMetaData.Message.Severity.valueOf(severity), msg);
                    ve.setPath(path);
                    model.addMessage(ve);
                    continue block7;
                }
                case METADATA: {
                    Properties metdataProps = VDBMetadataParser.getAttributes(reader);
                    String type = metdataProps.getProperty(Element.TYPE.getLocalName(), "DDL");
                    String schema = reader.getElementText();
                    model.setSchemaSourceType(type);
                    model.setSchemaText(schema);
                    continue block7;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element5", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PROPERTY.getLocalName(), Element.SOURCE.getLocalName(), Element.METADATA.getLocalName(), Element.VALIDATION_ERROR.getLocalName()}), reader.getLocation());
        }
    }

    private static Properties getAttributes(XMLStreamReader reader) {
        Properties props = new Properties();
        if (reader.getAttributeCount() > 0) {
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                props.setProperty(attrName, attrValue);
            }
        }
        return props;
    }

    public static void marshell(VDBMetaData vdb, OutputStream out) throws XMLStreamException, IOException {
        XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(out);
        writer.writeStartDocument();
        writer.writeStartElement(Element.VDB.getLocalName());
        VDBMetadataParser.writeAttribute(writer, Element.NAME.getLocalName(), vdb.getName());
        VDBMetadataParser.writeAttribute(writer, Element.VERSION.getLocalName(), String.valueOf(vdb.getVersion()));
        if (vdb.getDescription() != null) {
            VDBMetadataParser.writeElement(writer, Element.DESCRIPTION, vdb.getDescription());
        }
        VDBMetadataParser.writeProperties(writer, vdb.getProperties());
        for (VDBImport vDBImport : vdb.getVDBImports()) {
            writer.writeStartElement(Element.IMPORT_VDB.getLocalName());
            VDBMetadataParser.writeAttribute(writer, Element.NAME.getLocalName(), vDBImport.getName());
            VDBMetadataParser.writeAttribute(writer, Element.VERSION.getLocalName(), String.valueOf(vDBImport.getVersion()));
            VDBMetadataParser.writeAttribute(writer, Element.IMPORT_POLICIES.getLocalName(), String.valueOf(vDBImport.isImportDataPolicies()));
            writer.writeEndElement();
        }
        Collection<ModelMetaData> models = vdb.getModelMetaDatas().values();
        for (ModelMetaData model : models) {
            VDBMetadataParser.writeModel(writer, model);
        }
        for (Translator translator : vdb.getOverrideTranslators()) {
            VDBMetadataParser.writeTranslator(writer, translator);
        }
        for (DataPolicy dp : vdb.getDataPolicies()) {
            VDBMetadataParser.writeDataPolicy(writer, dp);
        }
        for (EntryMetaData em : vdb.getEntries()) {
            writer.writeStartElement(Element.ENTRY.getLocalName());
            VDBMetadataParser.writeAttribute(writer, Element.PATH.getLocalName(), em.getPath());
            if (em.getDescription() != null) {
                VDBMetadataParser.writeElement(writer, Element.DESCRIPTION, em.getDescription());
            }
            VDBMetadataParser.writeProperties(writer, em.getProperties());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
        out.close();
    }

    private static void writeDataPolicy(XMLStreamWriter writer, DataPolicy dp) throws XMLStreamException {
        writer.writeStartElement(Element.DATA_ROLE.getLocalName());
        VDBMetadataParser.writeAttribute(writer, Element.NAME.getLocalName(), dp.getName());
        VDBMetadataParser.writeAttribute(writer, Element.DATA_ROLE_ANY_ATHENTICATED_ATTR.getLocalName(), String.valueOf(dp.isAnyAuthenticated()));
        VDBMetadataParser.writeAttribute(writer, Element.DATA_ROLE_ALLOW_TEMP_TABLES_ATTR.getLocalName(), String.valueOf(dp.isAllowCreateTemporaryTables()));
        VDBMetadataParser.writeElement(writer, Element.DESCRIPTION, dp.getDescription());
        for (DataPolicy.DataPermission permission : dp.getPermissions()) {
            writer.writeStartElement(Element.PERMISSION.getLocalName());
            VDBMetadataParser.writeElement(writer, Element.RESOURCE_NAME, permission.getResourceName());
            if (permission.getAllowCreate() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_CREATE, permission.getAllowCreate().toString());
            }
            if (permission.getAllowRead() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_READ, permission.getAllowRead().toString());
            }
            if (permission.getAllowUpdate() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_UPADTE, permission.getAllowUpdate().toString());
            }
            if (permission.getAllowDelete() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_DELETE, permission.getAllowDelete().toString());
            }
            if (permission.getAllowExecute() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_EXECUTE, permission.getAllowExecute().toString());
            }
            if (permission.getAllowAlter() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_ALTER, permission.getAllowAlter().toString());
            }
            if (permission.getAllowLanguage() != null) {
                VDBMetadataParser.writeElement(writer, Element.ALLOW_LANGUAGE, permission.getAllowLanguage().toString());
            }
            writer.writeEndElement();
        }
        for (String roleName : dp.getMappedRoleNames()) {
            VDBMetadataParser.writeElement(writer, Element.MAPPED_ROLE_NAME, roleName);
        }
        writer.writeEndElement();
    }

    private static void writeTranslator(XMLStreamWriter writer, Translator translator) throws XMLStreamException {
        writer.writeStartElement(Element.TRANSLATOR.getLocalName());
        VDBMetadataParser.writeAttribute(writer, Element.NAME.getLocalName(), translator.getName());
        VDBMetadataParser.writeAttribute(writer, Element.TYPE.getLocalName(), translator.getType());
        VDBMetadataParser.writeAttribute(writer, Element.DESCRIPTION.getLocalName(), translator.getDescription());
        VDBMetadataParser.writeProperties(writer, translator.getProperties());
        writer.writeEndElement();
    }

    private static void writeModel(XMLStreamWriter writer, ModelMetaData model) throws XMLStreamException {
        writer.writeStartElement(Element.MODEL.getLocalName());
        VDBMetadataParser.writeAttribute(writer, Element.NAME.getLocalName(), model.getName());
        VDBMetadataParser.writeAttribute(writer, Element.TYPE.getLocalName(), model.getModelType().name());
        VDBMetadataParser.writeAttribute(writer, Element.VISIBLE.getLocalName(), String.valueOf(model.isVisible()));
        VDBMetadataParser.writeAttribute(writer, Element.PATH.getLocalName(), model.getPath());
        if (model.getDescription() != null) {
            VDBMetadataParser.writeElement(writer, Element.DESCRIPTION, model.getDescription());
        }
        VDBMetadataParser.writeProperties(writer, model.getProperties());
        for (SourceMappingMetadata source : model.getSourceMappings()) {
            writer.writeStartElement(Element.SOURCE.getLocalName());
            VDBMetadataParser.writeAttribute(writer, Element.NAME.getLocalName(), source.getName());
            VDBMetadataParser.writeAttribute(writer, Element.SOURCE_TRANSLATOR_NAME_ATTR.getLocalName(), source.getTranslatorName());
            VDBMetadataParser.writeAttribute(writer, Element.SOURCE_CONNECTION_JNDI_NAME_ATTR.getLocalName(), source.getConnectionJndiName());
            writer.writeEndElement();
        }
        if (model.getSchemaSourceType() != null) {
            writer.writeStartElement(Element.METADATA.getLocalName());
            VDBMetadataParser.writeAttribute(writer, Element.TYPE.getLocalName(), model.getSchemaSourceType());
            writer.writeCData(model.getSchemaText());
            writer.writeEndElement();
        }
        for (ModelMetaData.Message ve : model.getMessages(false)) {
            writer.writeStartElement(Element.VALIDATION_ERROR.getLocalName());
            VDBMetadataParser.writeAttribute(writer, Element.VALIDATION_SEVERITY_ATTR.getLocalName(), ve.getSeverity().name());
            VDBMetadataParser.writeAttribute(writer, Element.PATH.getLocalName(), ve.getPath());
            writer.writeCharacters(ve.getValue());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static void writeProperties(XMLStreamWriter writer, Properties props) throws XMLStreamException {
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            writer.writeStartElement(Element.PROPERTY.getLocalName());
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            VDBMetadataParser.writeAttribute(writer, Element.NAME.getLocalName(), key);
            VDBMetadataParser.writeAttribute(writer, Element.VALUE.getLocalName(), value);
            writer.writeEndElement();
        }
    }

    private static void writeAttribute(XMLStreamWriter writer, String localName, String value) throws XMLStreamException {
        if (value != null) {
            writer.writeAttribute(localName, value);
        }
    }

    private static void writeElement(XMLStreamWriter writer, Element element, String value) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
        writer.writeCharacters(value);
        writer.writeEndElement();
    }

    static enum Element {
        UNKNOWN(null),
        VDB("vdb"),
        NAME("name"),
        VERSION("version"),
        DESCRIPTION("description"),
        PROPERTY("property"),
        VALUE("value"),
        MODEL("model"),
        IMPORT_VDB("import-vdb"),
        IMPORT_POLICIES("import-data-policies"),
        TYPE("type"),
        VISIBLE("visible"),
        PATH("path"),
        SOURCE("source"),
        SOURCE_TRANSLATOR_NAME_ATTR("translator-name"),
        SOURCE_CONNECTION_JNDI_NAME_ATTR("connection-jndi-name"),
        VALIDATION_ERROR("validation-error"),
        VALIDATION_SEVERITY_ATTR("severity"),
        TRANSLATOR("translator"),
        DATA_ROLE("data-role"),
        DATA_ROLE_ANY_ATHENTICATED_ATTR("any-authenticated"),
        DATA_ROLE_ALLOW_TEMP_TABLES_ATTR("allow-create-temporary-tables"),
        PERMISSION("permission"),
        RESOURCE_NAME("resource-name"),
        ALLOW_CREATE("allow-create"),
        ALLOW_READ("allow-read"),
        ALLOW_UPADTE("allow-update"),
        ALLOW_DELETE("allow-delete"),
        ALLOW_EXECUTE("allow-execute"),
        ALLOW_ALTER("allow-alter"),
        ALLOW_LANGUAGE("allow-language"),
        MAPPED_ROLE_NAME("mapped-role-name"),
        ENTRY("entry"),
        METADATA("metadata");

        private final String name;
        private static final Map<String, Element> elements;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = elements.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            elements = map;
        }
    }
}

