/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.sample.controller;

import com.jaspersoft.jasperserver.sample.controller.WSServlet;
import com.jaspersoft.jasperserver.sample.controller.vo.UserWithAssignedMarkVO;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSRoleSearchCriteria;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import com.jaspersoft.jasperserver.ws.authority.WSUserSearchCriteria;
import com.jaspersoft.jasperserver.ws.client.authority.UserAndRoleManagement;
import com.jaspersoft.jasperserver.ws.client.controller.WSClientManager;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.ServiceException;

public class RoleServlet
extends WSServlet {
    public static final String ATTR_ROLES = "roles";
    public static final String ATTR_ROLE = "role";
    public static final String ATTR_USERS = "users";
    public static final String ATTR_SEARCH_NAME = "searchName";
    public static final String ATTR_VIEW_MODE = "viewMode";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_SEARCH_NAME = "searchName";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_PUT = "put";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_DELETE = "delete";
    public static final String PARAM_ROLE_NAME = "roleName";
    public static final String PARAM_OLD_ROLE_NAME = "oldRoleName";
    public static final String PARAM_TENANT_ID = "tenantId";
    public static final String PARAM_ENABLED = "enabled";
    public static final String PARAM_USER_PREFIX = "user_";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter(PARAM_ACTION);
        try {
            UserAndRoleManagement userAndRoleManagement = WSClientManager.getUserAndRoleManagement((String)this.getBaseAddress(request));
            if (ACTION_EDIT.equalsIgnoreCase(action)) {
                WSRole role = this.getEditRole(request, userAndRoleManagement);
                List<UserWithAssignedMarkVO> usersWithAssignedMark = this.getEditRolesAssignedMarks(request, userAndRoleManagement, role);
                if (role == null) {
                    response.sendRedirect(ATTR_ROLE);
                } else {
                    request.setAttribute(ATTR_ROLE, (Object)role);
                    request.setAttribute(ATTR_USERS, usersWithAssignedMark);
                    this.forward("authority/role.jsp", request, response);
                }
            }
            if (ACTION_PUT.equalsIgnoreCase(action)) {
                this.putRole(request, userAndRoleManagement);
                response.sendRedirect(ATTR_ROLE);
            }
            if (ACTION_DELETE.equalsIgnoreCase(action)) {
                this.deleteRole(request, userAndRoleManagement);
                response.sendRedirect(ATTR_ROLE);
            }
        }
        catch (Exception e) {
            this.forwardError(e, request, response);
        }
    }

    private List<UserWithAssignedMarkVO> getEditRolesAssignedMarks(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement, WSRole role) throws RemoteException {
        String roleName = request.getParameter(PARAM_ROLE_NAME);
        List<UserWithAssignedMarkVO> usersWithAssignedMark = roleName != null && roleName.length() > 0 ? this.getUsersWithAssignedMark(Arrays.asList(this.getAllUsersForRole(request, null, userAndRoleManagement)), Arrays.asList(this.getAllUsersForRole(request, role, userAndRoleManagement))) : this.getUsersWithAssignedMark(Arrays.asList(this.getAllUsersForRole(request, null, userAndRoleManagement)), Collections.EMPTY_LIST);
        return usersWithAssignedMark;
    }

    protected WSRole getEditRole(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        String roleName = request.getParameter(PARAM_ROLE_NAME);
        WSRole role = roleName != null && roleName.length() > 0 ? this.getRole(request, roleName, userAndRoleManagement) : new WSRole();
        return role;
    }

    protected void putRole(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        String roleName = request.getParameter(PARAM_ROLE_NAME);
        String oldRoleName = request.getParameter(PARAM_OLD_ROLE_NAME);
        WSRole role = new WSRole();
        role.setRoleName(roleName);
        if (oldRoleName != null && oldRoleName.length() > 0 && !oldRoleName.equals(roleName)) {
            role = this.getRole(request, oldRoleName, userAndRoleManagement);
            role = userAndRoleManagement.updateRoleName(role, roleName);
        }
        WSUser[] assignedUsers = this.getAssignedUsers(request, userAndRoleManagement);
        role.setUsers(assignedUsers);
        userAndRoleManagement.putRole(role);
    }

    protected void deleteRole(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        String roleName = request.getParameter(PARAM_ROLE_NAME);
        WSRole role = new WSRole();
        role.setRoleName(roleName);
        userAndRoleManagement.deleteRole(role);
    }

    protected WSUser[] getAssignedUsers(HttpServletRequest request, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        ArrayList<WSUser> users = new ArrayList<WSUser>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PARAM_USER_PREFIX)) continue;
            String name = key.substring(PARAM_USER_PREFIX.length());
            WSUser[] wsUsers = userAndRoleManagement.findUsers(new WSUserSearchCriteria(name, null, Boolean.valueOf(true), null, 0));
            if (wsUsers == null || wsUsers.length == 0) {
                throw new RuntimeException("Problems to find user with username '" + name + "'");
            }
            boolean foundUser = false;
            for (WSUser wsUser : wsUsers) {
                if (!wsUser.getUsername().equals(name)) continue;
                users.add(wsUser);
                foundUser = true;
            }
            if (foundUser) continue;
            throw new RuntimeException("Problems to find user with username '" + name + "'");
        }
        return users.toArray(new WSUser[users.size()]);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String searchName = request.getParameter("searchName");
        searchName = searchName != null ? searchName : "";
        try {
            UserAndRoleManagement userAndRoleManagement = WSClientManager.getUserAndRoleManagement((String)this.getBaseAddress(request));
            WSRoleSearchCriteria searchCriteria = this.createSearchCriteria(request, searchName);
            WSRole[] roles = userAndRoleManagement.findRoles(searchCriteria);
            request.setAttribute("searchName", (Object)searchName);
            request.setAttribute(ATTR_ROLES, (Object)roles);
            request.setAttribute(ATTR_VIEW_MODE, (Object)ATTR_ROLE);
            this.forward("authority/list.jsp", request, response);
        }
        catch (ServiceException e) {
            this.forwardError((Exception)((Object)e), request, response);
        }
    }

    protected WSRoleSearchCriteria createSearchCriteria(HttpServletRequest request, String searchName) throws RemoteException, ServiceException {
        WSRoleSearchCriteria searchCriteria = new WSRoleSearchCriteria();
        searchCriteria.setRoleName(searchName);
        searchCriteria.setTenantId(null);
        searchCriteria.setMaxRecords(0);
        searchCriteria.setIncludeSubOrgs(Boolean.TRUE);
        return searchCriteria;
    }

    protected WSRole getRole(HttpServletRequest request, String roleName, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        WSRole[] roles;
        WSRoleSearchCriteria searchCriteria = new WSRoleSearchCriteria();
        searchCriteria.setRoleName(roleName);
        searchCriteria.setTenantId(null);
        searchCriteria.setMaxRecords(0);
        searchCriteria.setIncludeSubOrgs(Boolean.TRUE);
        for (WSRole role : roles = userAndRoleManagement.findRoles(searchCriteria)) {
            if (!roleName.equals(role.getRoleName())) continue;
            return role;
        }
        return null;
    }

    protected WSUser[] getAllUsersForRole(HttpServletRequest request, WSRole role, UserAndRoleManagement userAndRoleManagement) throws RemoteException {
        WSRole[] wSRoleArray;
        Boolean bl = true;
        if (role == null) {
            wSRoleArray = null;
        } else {
            WSRole[] wSRoleArray2 = new WSRole[1];
            wSRoleArray = wSRoleArray2;
            wSRoleArray2[0] = role;
        }
        WSUserSearchCriteria searchCriteria = new WSUserSearchCriteria("", null, bl, wSRoleArray, 0);
        return userAndRoleManagement.findUsers(searchCriteria);
    }

    protected List<UserWithAssignedMarkVO> getUsersWithAssignedMark(Collection<WSUser> allUsers, Collection<WSUser> assignedUsers) {
        ArrayList<UserWithAssignedMarkVO> usersWithAssignedMark = new ArrayList<UserWithAssignedMarkVO>(allUsers.size());
        for (WSUser user : allUsers) {
            UserWithAssignedMarkVO userWithAssignedMarkVO = new UserWithAssignedMarkVO();
            userWithAssignedMarkVO.setUser(user);
            userWithAssignedMarkVO.setAssigned(assignedUsers.contains(user));
            usersWithAssignedMark.add(userWithAssignedMarkVO);
        }
        return usersWithAssignedMark;
    }
}

