/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.queryresults;

import java.io.IOException;
import org.mariadb.jdbc.internal.common.ColumnInformation;
import org.mariadb.jdbc.internal.common.PacketFetcher;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.ServerStatus;
import org.mariadb.jdbc.internal.common.ValueObject;
import org.mariadb.jdbc.internal.common.packet.EOFPacket;
import org.mariadb.jdbc.internal.common.packet.ErrorPacket;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacketFactory;
import org.mariadb.jdbc.internal.common.packet.ResultSetPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.ReadUtil;
import org.mariadb.jdbc.internal.common.queryresults.NoSuchColumnException;
import org.mariadb.jdbc.internal.common.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.mysql.MySQLColumnInformation;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;
import org.mariadb.jdbc.internal.mysql.packet.MySQLRowPacket;

public class StreamingSelectResult
extends SelectQueryResult {
    PacketFetcher packetFetcher;
    public ValueObject[] values;
    MySQLProtocol protocol;
    boolean isEOF;
    boolean beforeFirst;

    private StreamingSelectResult(ColumnInformation[] info, MySQLProtocol protocol, PacketFetcher fetcher) throws QueryException {
        this.columnInformation = info;
        this.protocol = protocol;
        this.packetFetcher = fetcher;
        this.beforeFirst = true;
        this.isEOF = false;
        protocol.activeResult = this;
    }

    public static StreamingSelectResult createStreamingSelectResult(ResultSetPacket packet, PacketFetcher packetFetcher, MySQLProtocol protocol) throws IOException, QueryException {
        if (protocol.activeResult != null) {
            throw new QueryException("There is an active result set on the current connection, which must be closed prior to opening a new one");
        }
        long fieldCount = packet.getFieldCount();
        ColumnInformation[] ci = new ColumnInformation[(int)fieldCount];
        int i = 0;
        while ((long)i < fieldCount) {
            RawPacket rawPacket = packetFetcher.getRawPacket();
            if (ReadUtil.isErrorPacket(rawPacket)) {
                ErrorPacket errorPacket = new ErrorPacket(rawPacket);
                throw new QueryException("error when reading field packet " + errorPacket.getMessage(), errorPacket.getErrorNumber(), errorPacket.getSqlState());
            }
            byte b = rawPacket.getByteBuffer().get(0);
            if (b == 0 || b == -2) {
                throw new QueryException("Packets out of order when trying to read field packet - got packet starting with byte " + b + "packet content (hex) = " + MySQLProtocol.hexdump(rawPacket.getByteBuffer(), 0));
            }
            try {
                ci[i] = new MySQLColumnInformation(rawPacket);
            }
            catch (Exception e) {
                throw new QueryException("Error when trying to parse field packet : " + e + ",packet content (hex) = " + MySQLProtocol.hexdump(rawPacket.getByteBuffer(), 0), 0, "HY000", e);
            }
            ++i;
        }
        RawPacket fieldEOF = packetFetcher.getRawPacket();
        if (!ReadUtil.eofIsNext(fieldEOF)) {
            throw new QueryException("Packets out of order when reading field packets, expected was EOF packet. Packet contents (hex) = " + MySQLProtocol.hexdump(fieldEOF.getByteBuffer(), 0));
        }
        return new StreamingSelectResult(ci, protocol, packetFetcher);
    }

    @Override
    public boolean next() throws IOException, QueryException {
        if (this.isEOF) {
            return false;
        }
        RawPacket rawPacket = this.packetFetcher.getRawPacket();
        if (ReadUtil.isErrorPacket(rawPacket)) {
            this.protocol.activeResult = null;
            this.protocol.moreResults = false;
            ErrorPacket errorPacket = (ErrorPacket)ResultPacketFactory.createResultPacket(rawPacket);
            throw new QueryException(errorPacket.getMessage(), errorPacket.getErrorNumber(), errorPacket.getSqlState());
        }
        if (ReadUtil.eofIsNext(rawPacket)) {
            EOFPacket eofPacket = (EOFPacket)ResultPacketFactory.createResultPacket(rawPacket);
            this.protocol.activeResult = null;
            this.protocol.moreResults = eofPacket.getStatusFlags().contains((Object)ServerStatus.MORE_RESULTS_EXISTS);
            this.warningCount = eofPacket.getWarningCount();
            this.protocol.hasWarnings = this.warningCount > 0;
            this.isEOF = true;
            this.values = null;
            return false;
        }
        MySQLRowPacket rowPacket = new MySQLRowPacket(rawPacket, this.columnInformation);
        this.values = rowPacket.getRow(this.packetFetcher);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        if (this.protocol != null && this.protocol.activeResult == this) {
            try {
                while (true) {
                    if (this.protocol.activeResult == null) {
                        return;
                    }
                    if (this.next()) continue;
                    return;
                }
            }
            catch (QueryException qe) {
                return;
            }
            catch (IOException ioe) {
                return;
            }
            finally {
                this.protocol.activeResult = null;
                this.protocol = null;
                this.packetFetcher = null;
            }
        }
    }

    @Override
    public ValueObject getValueObject(int i) throws NoSuchColumnException {
        return this.values[i];
    }

    @Override
    public int getRows() {
        return -1;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.beforeFirst;
    }

    @Override
    public boolean isAfterLast() {
        return this.isEOF;
    }
}

