/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;

public final class Driver
implements java.sql.Driver {
    private static final Logger log = Logger.getLogger(Driver.class.getName());

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String baseUrl = url;
        int idx = url.lastIndexOf("?");
        if (idx > 0) {
            baseUrl = url.substring(0, idx);
            String urlParams = url.substring(idx + 1);
            this.setURLParameters(urlParams, info);
        }
        log.finest("Connecting to: " + url);
        try {
            JDBCUrl jdbcUrl = JDBCUrl.parse(baseUrl);
            if (jdbcUrl == null) {
                return null;
            }
            String userName = info.getProperty("user", jdbcUrl.getUsername());
            String password = info.getProperty("password", jdbcUrl.getPassword());
            MySQLProtocol protocol = new MySQLProtocol(jdbcUrl, userName, password, info);
            return MySQLConnection.newConnection(protocol);
        }
        catch (QueryException e) {
            SQLExceptionMapper.throwException(e, null, null);
            return null;
        }
    }

    private void setURLParameters(String urlParameters, Properties info) {
        String[] parameters;
        for (String param : parameters = urlParameters.split("&")) {
            int pos = param.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException("Invalid connection URL, expected key=value pairs, found " + param);
            }
            info.setProperty(param.substring(0, pos), param.substring(pos + 1));
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        return JDBCUrl.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register driver", e);
        }
    }
}

