/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.utils;

import java.util.ArrayList;
import java.util.List;
import org.ovirt.engine.sdk.entities.KeyValuePair;
import org.ovirt.engine.sdk.utils.UrlHelper;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class UrlBuilder {
    private String url;
    private List<UrlParameter> params;

    public UrlBuilder(String url) {
        this.url = url;
        this.params = new ArrayList<UrlParameter>();
    }

    public UrlBuilder add(String key, Object value, UrlParameterType type) {
        this.params.add(new UrlParameter(key, value != null ? String.valueOf(value) : null, type));
        return this;
    }

    public UrlBuilder add(String key, UrlParameterType type) {
        this.params.add(new UrlParameter(key, null, type));
        return this;
    }

    public String build() {
        StringBuffer matrixParams = new StringBuffer();
        StringBuffer queryParams = new StringBuffer();
        for (UrlParameter urlParam : this.params) {
            if (urlParam.getValue() == null) continue;
            switch (urlParam.getType()) {
                case MATRIX: {
                    matrixParams.append(";" + urlParam.getKey() + "=" + urlParam.getValue());
                    break;
                }
                case QUERY: {
                    queryParams.append("?" + urlParam.getKey() + "=" + UrlHelper.encode(urlParam.getValue()));
                }
            }
        }
        return this.url + matrixParams.toString() + queryParams.toString();
    }

    private static class UrlParameter
    extends KeyValuePair {
        private UrlParameterType type;

        public UrlParameter(String key, String value, UrlParameterType type) {
            this.setKey(key);
            this.setValue(value);
            this.setType(type);
        }

        private void setType(UrlParameterType type) {
            this.type = type;
        }

        public UrlParameterType getType() {
            return this.type;
        }
    }
}

