/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.VMSnapshot;
import org.ovirt.engine.sdk.decorators.VMSnapshotCdRom;
import org.ovirt.engine.sdk.entities.CdRom;
import org.ovirt.engine.sdk.entities.CdRoms;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class VMSnapshotCdRoms
extends CollectionDecorator<CdRom, CdRoms, VMSnapshotCdRom> {
    private VMSnapshot parent;

    public VMSnapshotCdRoms(HttpProxyBroker proxy, VMSnapshot parent) {
        super(proxy, "cdroms");
        this.parent = parent;
    }

    @Override
    public List<VMSnapshotCdRom> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, CdRoms.class, VMSnapshotCdRom.class);
    }

    @Override
    public VMSnapshotCdRom get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, CdRom.class, VMSnapshotCdRom.class);
    }

    @Override
    public VMSnapshotCdRom getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, CdRom.class, VMSnapshotCdRom.class);
    }

    public List<VMSnapshotCdRom> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, CdRoms.class, VMSnapshotCdRom.class, headers);
    }
}

