/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.StorageDomainTemplate;
import org.ovirt.engine.sdk.decorators.StorageDomainTemplateDisk;
import org.ovirt.engine.sdk.entities.Disk;
import org.ovirt.engine.sdk.entities.Disks;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class StorageDomainTemplateDisks
extends CollectionDecorator<Disk, Disks, StorageDomainTemplateDisk> {
    private StorageDomainTemplate parent;

    public StorageDomainTemplateDisks(HttpProxyBroker proxy, StorageDomainTemplate parent) {
        super(proxy, "disks");
        this.parent = parent;
    }

    @Override
    public List<StorageDomainTemplateDisk> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Disks.class, StorageDomainTemplateDisk.class);
    }

    @Override
    public StorageDomainTemplateDisk get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Disk.class, StorageDomainTemplateDisk.class);
    }

    @Override
    public StorageDomainTemplateDisk getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Disk.class, StorageDomainTemplateDisk.class);
    }

    public List<StorageDomainTemplateDisk> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, Disks.class, StorageDomainTemplateDisk.class, headers);
    }
}

