/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Network;
import org.ovirt.engine.sdk.decorators.NetworkVnicProfile;
import org.ovirt.engine.sdk.entities.VnicProfile;
import org.ovirt.engine.sdk.entities.VnicProfiles;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class NetworkVnicProfiles
extends CollectionDecorator<VnicProfile, VnicProfiles, NetworkVnicProfile> {
    private Network parent;

    public NetworkVnicProfiles(HttpProxyBroker proxy, Network parent) {
        super(proxy, "vnicprofiles");
        this.parent = parent;
    }

    @Override
    public List<NetworkVnicProfile> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, VnicProfiles.class, NetworkVnicProfile.class);
    }

    @Override
    public NetworkVnicProfile get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, VnicProfile.class, NetworkVnicProfile.class);
    }

    @Override
    public NetworkVnicProfile getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, VnicProfile.class, NetworkVnicProfile.class);
    }

    public NetworkVnicProfile add(VnicProfile vnicprofile) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vnicprofile, VnicProfile.class, NetworkVnicProfile.class, headers);
    }

    public NetworkVnicProfile add(VnicProfile vnicprofile, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vnicprofile, VnicProfile.class, NetworkVnicProfile.class, headers);
    }

    public NetworkVnicProfile add(VnicProfile vnicprofile, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vnicprofile, VnicProfile.class, NetworkVnicProfile.class, headers);
    }

    public List<NetworkVnicProfile> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, VnicProfiles.class, NetworkVnicProfile.class, headers);
    }
}

