/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Event;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Events
extends CollectionDecorator<org.ovirt.engine.sdk.entities.Event, org.ovirt.engine.sdk.entities.Events, Event> {
    public Events(HttpProxyBroker proxy) {
        super(proxy, "events");
    }

    @Override
    public List<Event> list() throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        return this.list(url, org.ovirt.engine.sdk.entities.Events.class, Event.class);
    }

    @Override
    public Event get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.Event.class, Event.class);
    }

    @Override
    public Event getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.Event.class, Event.class);
    }

    public Event add(org.ovirt.engine.sdk.entities.Event event) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, event, org.ovirt.engine.sdk.entities.Event.class, Event.class, headers);
    }

    public Event add(org.ovirt.engine.sdk.entities.Event event, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, event, org.ovirt.engine.sdk.entities.Event.class, Event.class, headers);
    }

    public Event add(org.ovirt.engine.sdk.entities.Event event, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, event, org.ovirt.engine.sdk.entities.Event.class, Event.class, headers);
    }

    public List<Event> list(String query) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.Events.class, Event.class, headers);
    }

    public List<Event> list(String query, Boolean caseSensitive) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.Events.class, Event.class, headers);
    }

    public List<Event> list(String query, Boolean caseSensitive, String from) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        if (from != null) {
            urlBuilder.add("from", from, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.Events.class, Event.class, headers);
    }

    public List<Event> list(String query, Boolean caseSensitive, String from, Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        if (from != null) {
            urlBuilder.add("from", from, UrlParameterType.MATRIX);
        }
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.Events.class, Event.class, headers);
    }
}

