/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Disk;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Disks
extends CollectionDecorator<org.ovirt.engine.sdk.entities.Disk, org.ovirt.engine.sdk.entities.Disks, Disk> {
    public Disks(HttpProxyBroker proxy) {
        super(proxy, "disks");
    }

    @Override
    public List<Disk> list() throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        return this.list(url, org.ovirt.engine.sdk.entities.Disks.class, Disk.class);
    }

    @Override
    public Disk get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.Disk.class, Disk.class);
    }

    @Override
    public Disk getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.Disk.class, Disk.class);
    }

    public Disk add(org.ovirt.engine.sdk.entities.Disk disk) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, disk, org.ovirt.engine.sdk.entities.Disk.class, Disk.class, headers);
    }

    public Disk add(org.ovirt.engine.sdk.entities.Disk disk, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, disk, org.ovirt.engine.sdk.entities.Disk.class, Disk.class, headers);
    }

    public Disk add(org.ovirt.engine.sdk.entities.Disk disk, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, disk, org.ovirt.engine.sdk.entities.Disk.class, Disk.class, headers);
    }

    public List<Disk> list(String query) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.Disks.class, Disk.class, headers);
    }

    public List<Disk> list(String query, Boolean caseSensitive) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.Disks.class, Disk.class, headers);
    }

    public List<Disk> list(String query, Boolean caseSensitive, Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (query != null) {
            urlBuilder.add("search", query, UrlParameterType.QUERY);
        }
        if (caseSensitive != null) {
            urlBuilder.add("case_sensitive", caseSensitive, UrlParameterType.MATRIX);
        }
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.Disks.class, Disk.class, headers);
    }
}

