/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk;

import java.io.IOException;
import org.ovirt.engine.sdk.Api;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.exceptions.UnsecuredConnectionAttemptError;

public class ApiBuilder {
    private String url;
    private String user;
    private String password;
    private String sessionId;
    private Integer requestTimeout;
    private Integer sessionTimeout;
    private Boolean persistentAuth;
    private Boolean noHostVerification;
    private String keyStorePath;
    private String keyStorePassword;
    private Boolean filter;
    private Boolean debug;
    private Boolean kerberos;

    public ApiBuilder url(String url) {
        this.url = url;
        return this;
    }

    public ApiBuilder user(String user) {
        this.user = user;
        return this;
    }

    public ApiBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ApiBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public ApiBuilder requestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public ApiBuilder sessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public ApiBuilder persistentAuth(Boolean persistentAuth) {
        this.persistentAuth = persistentAuth;
        return this;
    }

    public ApiBuilder noHostVerification(Boolean noHostVerification) {
        this.noHostVerification = noHostVerification;
        return this;
    }

    public ApiBuilder keyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public ApiBuilder keyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public ApiBuilder filter(Boolean filter) {
        this.filter = filter;
        return this;
    }

    public ApiBuilder debug(Boolean debug) {
        this.debug = debug;
        return this;
    }

    public ApiBuilder kerberos(Boolean kerberos) {
        this.kerberos = kerberos;
        return this;
    }

    public Api build() throws ServerException, UnsecuredConnectionAttemptError, IOException {
        return new Api(this.url, this.user, this.password, this.sessionId, null, this.requestTimeout, this.sessionTimeout, this.persistentAuth, this.noHostVerification, this.keyStorePath, this.keyStorePassword, this.filter, this.debug, this.kerberos);
    }
}

