/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.types.Domain;

/**
 * A service to view details of an authentication domain in the system.
 */
public interface DomainService extends Service {
    /**
     * Gets the authentication domain information.
     * 
     * Usage:
     * 
     * ....
     * GET /ovirt-engine/api/domains/5678
     * ....
     * 
     * Will return the domain information:
     * 
     * [source,xml]
     * ----
     * <domain href="/ovirt-engine/api/domains/5678" id="5678">
     *   <name>internal-authz</name>
     *   <link href="/ovirt-engine/api/domains/5678/users" rel="users"/>
     *   <link href="/ovirt-engine/api/domains/5678/groups" rel="groups"/>
     *   <link href="/ovirt-engine/api/domains/5678/users?search={query}" rel="users/search"/>
     *   <link href="/ovirt-engine/api/domains/5678/groups?search={query}" rel="groups/search"/>
     * </domain>
     * ----
     */
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    /**
     * Gets the authentication domain information.
     * 
     * Usage:
     * 
     * ....
     * GET /ovirt-engine/api/domains/5678
     * ....
     * 
     * Will return the domain information:
     * 
     * [source,xml]
     * ----
     * <domain href="/ovirt-engine/api/domains/5678" id="5678">
     *   <name>internal-authz</name>
     *   <link href="/ovirt-engine/api/domains/5678/users" rel="users"/>
     *   <link href="/ovirt-engine/api/domains/5678/groups" rel="groups"/>
     *   <link href="/ovirt-engine/api/domains/5678/users?search={query}" rel="users/search"/>
     *   <link href="/ovirt-engine/api/domains/5678/groups?search={query}" rel="groups/search"/>
     * </domain>
     * ----
     */
    public interface GetResponse extends Response {
        /**
         * The authentication domain.
         */
        Domain domain();
    }
    
    /**
     * Gets the authentication domain information.
     * 
     * Usage:
     * 
     * ....
     * GET /ovirt-engine/api/domains/5678
     * ....
     * 
     * Will return the domain information:
     * 
     * [source,xml]
     * ----
     * <domain href="/ovirt-engine/api/domains/5678" id="5678">
     *   <name>internal-authz</name>
     *   <link href="/ovirt-engine/api/domains/5678/users" rel="users"/>
     *   <link href="/ovirt-engine/api/domains/5678/groups" rel="groups"/>
     *   <link href="/ovirt-engine/api/domains/5678/users?search={query}" rel="users/search"/>
     *   <link href="/ovirt-engine/api/domains/5678/groups?search={query}" rel="groups/search"/>
     * </domain>
     * ----
     */
    GetRequest get();
    
    /**
     * Reference to a service to manage domain groups.
     */
    DomainGroupsService groupsService();
    /**
     * Reference to a service to manage domain users.
     */
    DomainUsersService usersService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

