/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.ovirt.engine.sdk4.Error;

public class SsoUtils {
    private static final String ENTRY_POINT_HTTP = "token-http-auth";
    private static final String ENTRY_POINT_TOKEN = "token";

    public static URI buildSsoUrlBasic(String url) {
        try {
            URI uri = new URI(url);
            URIBuilder uriBuilder = new URIBuilder(String.format("%1$s://%2$s/ovirt-engine/sso/oauth/%3$s", uri.getScheme(), uri.getAuthority(), ENTRY_POINT_TOKEN));
            return uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            throw new Error("Failed to build SSO authentication URL", ex);
        }
    }

    public static URI buildSsoUrlKerberos(String url) {
        try {
            URI uri = new URI(url);
            URIBuilder uriBuilder = new URIBuilder(String.format("%1$s://%2$s/ovirt-engine/sso/oauth/%3$s", uri.getScheme(), uri.getAuthority(), ENTRY_POINT_HTTP));
            return uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            throw new Error("Failed to build SSO authentication URL", ex);
        }
    }

    public static URI buildSsoRevokeUrl(String url) {
        try {
            URI uri = new URI(url);
            URIBuilder uriBuilder = new URIBuilder(String.format("%1$s://%2$s/ovirt-engine/services/sso-logout", uri.getScheme(), uri.getAuthority()));
            return uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            throw new Error("Failed to build SSO revoke URL", ex);
        }
    }

    public static URI buildUrl(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new Error("Failed to build URL", ex);
        }
    }
}

