/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.xml;

import java.util.Iterator;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.types.Job;

public class XmlJobWriter {
    
    public static void writeOne(Job object, XmlWriter writer) {
        writeOne(object, "job", writer);
    }
    
    public static void writeOne(Job object, String tag, XmlWriter writer) {
        writer.writeStartElement(tag);
        if (object.hrefPresent()) {
            writer.writeAttribute("href", object.href());
        }
        if (object.idPresent()) {
            writer.writeAttribute("id", object.id());
        }
        if (object.autoClearedPresent()) {
            writer.writeBoolean("auto_cleared", object.autoCleared());
        }
        if (object.commentPresent()) {
            writer.writeElement("comment", object.comment());
        }
        if (object.descriptionPresent()) {
            writer.writeElement("description", object.description());
        }
        if (object.endTimePresent()) {
            writer.writeDate("end_time", object.endTime());
        }
        if (object.externalPresent()) {
            writer.writeBoolean("external", object.external());
        }
        if (object.lastUpdatedPresent()) {
            writer.writeDate("last_updated", object.lastUpdated());
        }
        if (object.namePresent()) {
            writer.writeElement("name", object.name());
        }
        if (object.ownerPresent()) {
            XmlUserWriter.writeOne(object.owner(), "owner", writer);
        }
        if (object.startTimePresent()) {
            writer.writeDate("start_time", object.startTime());
        }
        if (object.statusPresent()) {
            XmlJobStatusWriter.writeOne(object.status(), "status", writer);
        }
        if (object.stepsPresent()) {
            XmlStepWriter.writeMany(object.steps().iterator(), "step", "steps", writer);
        }
        writer.writeEndElement();
    }
    
    public static void writeMany(Iterator<Job> list, XmlWriter writer) {
        writeMany(list, "job", "jobs", writer);
    }
    
    public static void writeMany(Iterator<Job> list, String singular, String plural, XmlWriter writer) {
        writer.writeStartElement(plural);
        while (list.hasNext()) {
            XmlJobWriter.writeOne(list.next(), singular, writer);
        }
        writer.writeEndElement();
    }
    
}

