/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.xml;

import java.util.Iterator;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.types.GlusterClient;

public class XmlGlusterClientWriter {
    
    public static void writeOne(GlusterClient object, XmlWriter writer) {
        writeOne(object, "gluster_client", writer);
    }
    
    public static void writeOne(GlusterClient object, String tag, XmlWriter writer) {
        writer.writeStartElement(tag);
        if (object.bytesReadPresent()) {
            writer.writeInteger("bytes_read", object.bytesRead());
        }
        if (object.bytesWrittenPresent()) {
            writer.writeInteger("bytes_written", object.bytesWritten());
        }
        if (object.clientPortPresent()) {
            writer.writeInteger("client_port", object.clientPort());
        }
        if (object.hostNamePresent()) {
            writer.writeElement("host_name", object.hostName());
        }
        writer.writeEndElement();
    }
    
    public static void writeMany(Iterator<GlusterClient> list, XmlWriter writer) {
        writeMany(list, "gluster_client", "gluster_clients", writer);
    }
    
    public static void writeMany(Iterator<GlusterClient> list, String singular, String plural, XmlWriter writer) {
        writer.writeStartElement(plural);
        while (list.hasNext()) {
            XmlGlusterClientWriter.writeOne(list.next(), singular, writer);
        }
        writer.writeEndElement();
    }
    
}

