/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.HostNicVirtualFunctionsConfiguration;

public class HostNicVirtualFunctionsConfigurationContainer extends Container implements HostNicVirtualFunctionsConfiguration {
    private Boolean allNetworksAllowed;
    private BigInteger maxNumberOfVirtualFunctions;
    private BigInteger numberOfVirtualFunctions;
    
    public boolean allNetworksAllowed() {
        return allNetworksAllowed;
    }
    
    public void allNetworksAllowed(boolean newAllNetworksAllowed) {
        allNetworksAllowed = Boolean.valueOf(newAllNetworksAllowed);
    }
    
    public void allNetworksAllowed(Boolean newAllNetworksAllowed) {
        allNetworksAllowed = newAllNetworksAllowed;
    }
    
    public boolean allNetworksAllowedPresent() {
        return allNetworksAllowed != null;
    }
    
    public BigInteger maxNumberOfVirtualFunctions() {
        return maxNumberOfVirtualFunctions;
    }
    
    public Byte maxNumberOfVirtualFunctionsAsByte() {
        return asByte("HostNicVirtualFunctionsConfiguration", "maxNumberOfVirtualFunctions", maxNumberOfVirtualFunctions);
    }
    
    public Short maxNumberOfVirtualFunctionsAsShort() {
        return asShort("HostNicVirtualFunctionsConfiguration", "maxNumberOfVirtualFunctions", maxNumberOfVirtualFunctions);
    }
    
    public Integer maxNumberOfVirtualFunctionsAsInteger() {
        return asInteger("HostNicVirtualFunctionsConfiguration", "maxNumberOfVirtualFunctions", maxNumberOfVirtualFunctions);
    }
    
    public Long maxNumberOfVirtualFunctionsAsLong() {
        return asLong("HostNicVirtualFunctionsConfiguration", "maxNumberOfVirtualFunctions", maxNumberOfVirtualFunctions);
    }
    
    public void maxNumberOfVirtualFunctions(BigInteger newMaxNumberOfVirtualFunctions) {
        maxNumberOfVirtualFunctions = newMaxNumberOfVirtualFunctions;
    }
    
    public boolean maxNumberOfVirtualFunctionsPresent() {
        return maxNumberOfVirtualFunctions != null;
    }
    
    public BigInteger numberOfVirtualFunctions() {
        return numberOfVirtualFunctions;
    }
    
    public Byte numberOfVirtualFunctionsAsByte() {
        return asByte("HostNicVirtualFunctionsConfiguration", "numberOfVirtualFunctions", numberOfVirtualFunctions);
    }
    
    public Short numberOfVirtualFunctionsAsShort() {
        return asShort("HostNicVirtualFunctionsConfiguration", "numberOfVirtualFunctions", numberOfVirtualFunctions);
    }
    
    public Integer numberOfVirtualFunctionsAsInteger() {
        return asInteger("HostNicVirtualFunctionsConfiguration", "numberOfVirtualFunctions", numberOfVirtualFunctions);
    }
    
    public Long numberOfVirtualFunctionsAsLong() {
        return asLong("HostNicVirtualFunctionsConfiguration", "numberOfVirtualFunctions", numberOfVirtualFunctions);
    }
    
    public void numberOfVirtualFunctions(BigInteger newNumberOfVirtualFunctions) {
        numberOfVirtualFunctions = newNumberOfVirtualFunctions;
    }
    
    public boolean numberOfVirtualFunctionsPresent() {
        return numberOfVirtualFunctions != null;
    }
    
}
