/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.TimeZoneContainer;
import org.ovirt.engine.sdk4.types.TimeZone;

public class TimeZoneBuilder {
    private String name;
    private String utcOffset;
    
    public TimeZoneBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public TimeZoneBuilder utcOffset(String newUtcOffset) {
        utcOffset = newUtcOffset;
        return this;
    }
    
    
    public TimeZone build() {
        TimeZoneContainer container = new TimeZoneContainer();
        container.name(name);
        container.utcOffset(utcOffset);
        return container;
    }
}
