/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StorageDomainType {
    DATA("data"),
    EXPORT("export"),
    IMAGE("image"),
    ISO("iso"),
    VOLUME("volume");

    private static final Logger log;
    private String image;

    private StorageDomainType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static StorageDomainType fromValue(String value) {
        try {
            return StorageDomainType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'StorageDomainType' enumerated type. Valid values are 'data', 'export', 'image', 'iso' and 'volume'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(StorageDomainType.class);
    }
}

