/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QosType {
    CPU("cpu"),
    HOSTNETWORK("hostnetwork"),
    NETWORK("network"),
    STORAGE("storage");

    private static final Logger log;
    private String image;

    private QosType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static QosType fromValue(String value) {
        try {
            return QosType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'QosType' enumerated type. Valid values are 'cpu', 'hostnetwork', 'network' and 'storage'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(QosType.class);
    }
}

